/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataDiff;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionDiff;
import org.onosproject.cluster.PartitionId;

public class ClusterMetadataDiffTest {
    @Test
    public void testDiffNoChange() {
        PartitionId pid1 = PartitionId.from((int)1);
        NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
        DefaultControllerNode n1 = new DefaultControllerNode(nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
        DefaultPartition p1 = new DefaultPartition(pid1, (Collection)ImmutableSet.of((Object)nid1));
        ClusterMetadata md1 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)n1), (Set)ImmutableSet.of((Object)p1));
        ClusterMetadataDiff diff = new ClusterMetadataDiff(md1, md1);
        Assert.assertTrue((boolean)diff.nodesAdded().isEmpty());
        Assert.assertTrue((boolean)diff.nodesRemoved().isEmpty());
        Assert.assertEquals((long)diff.partitionDiffs().size(), (long)1L);
        Assert.assertEquals(diff.partitionDiffs().keySet(), (Object)Sets.newHashSet((Object[])new PartitionId[]{pid1}));
        PartitionDiff pdiff = (PartitionDiff)diff.partitionDiffs().get(pid1);
        Assert.assertFalse((boolean)pdiff.hasChanged());
    }

    @Test
    public void testDiffForScaleUp() {
        PartitionId pid1 = PartitionId.from((int)1);
        NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
        NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
        DefaultControllerNode n1 = new DefaultControllerNode(nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
        DefaultControllerNode n2 = new DefaultControllerNode(nid2, IpAddress.valueOf((String)"10.0.0.2"), 9876);
        DefaultPartition p1 = new DefaultPartition(pid1, (Collection)ImmutableSet.of((Object)nid1));
        DefaultPartition p12 = new DefaultPartition(pid1, (Collection)ImmutableSet.of((Object)nid1, (Object)nid2));
        ClusterMetadata md1 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)n1), (Set)ImmutableSet.of((Object)p1));
        ClusterMetadata md12 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)n1, (Object)n2), (Set)ImmutableSet.of((Object)p12));
        ClusterMetadataDiff diff = new ClusterMetadataDiff(md1, md12);
        Assert.assertEquals((Object)diff.nodesAdded(), (Object)Sets.newHashSet((Object[])new ControllerNode[]{n2}));
        Assert.assertTrue((boolean)diff.nodesRemoved().isEmpty());
        Assert.assertEquals((long)diff.partitionDiffs().size(), (long)1L);
        Assert.assertEquals(diff.partitionDiffs().keySet(), (Object)Sets.newHashSet((Object[])new PartitionId[]{pid1}));
        PartitionDiff pdiff = (PartitionDiff)diff.partitionDiffs().get(pid1);
        Assert.assertTrue((boolean)pdiff.hasChanged());
        Assert.assertFalse((boolean)pdiff.isAdded(nid1));
        Assert.assertTrue((boolean)pdiff.isAdded(nid2));
        Assert.assertFalse((boolean)pdiff.isRemoved(nid1));
        Assert.assertFalse((boolean)pdiff.isAdded(nid1));
    }

    @Test
    public void testDiffForScaleDown() {
        PartitionId pid1 = PartitionId.from((int)1);
        NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
        NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
        DefaultControllerNode n1 = new DefaultControllerNode(nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
        DefaultControllerNode n2 = new DefaultControllerNode(nid2, IpAddress.valueOf((String)"10.0.0.2"), 9876);
        DefaultPartition p1 = new DefaultPartition(pid1, (Collection)ImmutableSet.of((Object)nid1));
        DefaultPartition p12 = new DefaultPartition(pid1, (Collection)ImmutableSet.of((Object)nid1, (Object)nid2));
        ClusterMetadata md1 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)n1), (Set)ImmutableSet.of((Object)p1));
        ClusterMetadata md12 = new ClusterMetadata("foo", (Set)ImmutableSet.of((Object)n1, (Object)n2), (Set)ImmutableSet.of((Object)p12));
        ClusterMetadataDiff diff = new ClusterMetadataDiff(md12, md1);
        Assert.assertEquals((Object)diff.nodesRemoved(), (Object)Sets.newHashSet((Object[])new NodeId[]{nid2}));
        Assert.assertTrue((boolean)diff.nodesAdded().isEmpty());
        Assert.assertEquals((long)diff.partitionDiffs().size(), (long)1L);
        Assert.assertEquals(diff.partitionDiffs().keySet(), (Object)Sets.newHashSet((Object[])new PartitionId[]{pid1}));
        PartitionDiff pdiff = (PartitionDiff)diff.partitionDiffs().get(pid1);
        Assert.assertTrue((boolean)pdiff.hasChanged());
        Assert.assertTrue((boolean)pdiff.isRemoved(nid2));
        Assert.assertFalse((boolean)pdiff.isAdded(nid2));
        Assert.assertFalse((boolean)pdiff.isRemoved(nid1));
        Assert.assertFalse((boolean)pdiff.isAdded(nid1));
    }
}

