/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.onosproject.net.group.GroupKey;

public class DefaultGroupKey
implements GroupKey {
    private final byte[] key;
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public DefaultGroupKey(byte[] key) {
        this.key = (byte[])Preconditions.checkNotNull((Object)key);
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultGroupKey)) {
            return false;
        }
        DefaultGroupKey that = (DefaultGroupKey)o;
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        char[] hexChars = new char[this.key.length * 2];
        for (int j = 0; j < this.key.length; ++j) {
            int v = this.key[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return "0x" + new String(hexChars);
    }
}

