/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverDataTest;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.TestBehaviour;
import org.onosproject.net.driver.TestBehaviourImpl;
import org.onosproject.net.driver.TestBehaviourTwo;
import org.onosproject.net.driver.TestBehaviourTwoImpl;

public class DefaultDriverTest {
    private static final String MFR = "mfr";
    private static final String HW = "hw";
    private static final String SW = "sw";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String ROOT = "rootDriver";
    private static final String CHILD = "childDriver";
    private static final String GRAND_CHILD = "grandChilDriver";

    @Test
    public void basics() {
        DefaultDriver ddp = new DefaultDriver("foo.base", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class, TestBehaviourTwo.class, TestBehaviourTwoImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        DefaultDriver ddc = new DefaultDriver("foo.bar", (List)ImmutableList.of((Object)ddp), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((String)"incorrect name", (Object)"foo.bar", (Object)ddc.name());
        Assert.assertEquals((String)"incorrect parent", (Object)ddp, (Object)ddc.parent());
        Assert.assertEquals((String)"incorrect empty parent", (Object)ImmutableList.of(), (Object)ddp.parents());
        Assert.assertEquals((String)"incorrect mfr", (Object)"Circus", (Object)ddc.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)"lux", (Object)ddc.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)"1.2a", (Object)ddc.swVersion());
        Assert.assertEquals((String)"incorrect behaviour count", (long)2L, (long)ddp.behaviours().size());
        Assert.assertEquals((String)"incorrect behaviour count", (long)0L, (long)ddc.behaviours().size());
        Assert.assertTrue((String)"incorrect behaviour", (boolean)ddc.hasBehaviour(TestBehaviour.class));
        Behaviour b1 = ddc.createBehaviour((DriverData)new DefaultDriverData((Driver)ddc, DefaultDriverDataTest.DEVICE_ID), TestBehaviour.class);
        Assert.assertTrue((String)"incorrect behaviour class", (boolean)(b1 instanceof TestBehaviourImpl));
        Behaviour b2 = ddc.createBehaviour((DriverHandler)new DefaultDriverHandler((DriverData)new DefaultDriverData((Driver)ddc, DefaultDriverDataTest.DEVICE_ID)), TestBehaviourTwo.class);
        Assert.assertTrue((String)"incorrect behaviour class", (boolean)(b2 instanceof TestBehaviourTwoImpl));
        Assert.assertEquals((String)"incorrect property count", (long)1L, (long)ddc.properties().size());
        Assert.assertEquals((String)"incorrect key count", (long)1L, (long)ddc.keys().size());
        Assert.assertEquals((String)"incorrect property", (Object)"bar", (Object)ddc.value("foo"));
        Assert.assertTrue((String)"incorrect toString", (boolean)ddc.toString().contains("lux"));
    }

    @Test
    public void merge() {
        DefaultDriver one = new DefaultDriver("foo.bar", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Driver ddc = one.merge((Driver)new DefaultDriver("foo.bar", new ArrayList(), "", "", "", (Map)ImmutableMap.of(TestBehaviourTwo.class, TestBehaviourTwoImpl.class), (Map)ImmutableMap.of((Object)"goo", (Object)"wee")));
        Assert.assertEquals((String)"incorrect name", (Object)"foo.bar", (Object)ddc.name());
        Assert.assertEquals((String)"incorrect mfr", (Object)"Circus", (Object)ddc.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)"lux", (Object)ddc.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)"1.2a", (Object)ddc.swVersion());
        Assert.assertEquals((String)"incorrect behaviour count", (long)2L, (long)ddc.behaviours().size());
        Assert.assertTrue((String)"incorrect behaviour", (boolean)ddc.hasBehaviour(TestBehaviourTwo.class));
        Assert.assertEquals((String)"incorrect property count", (long)2L, (long)ddc.properties().size());
        Assert.assertEquals((String)"incorrect key count", (long)2L, (long)ddc.keys().size());
        Assert.assertEquals((String)"incorrect property", (Object)"wee", (Object)ddc.value("goo"));
        Assert.assertTrue((String)"incorrect toString", (boolean)ddc.toString().contains("Circus"));
    }

    @Test
    public void testGetProperty() throws Exception {
        DefaultDriver root = new DefaultDriver(ROOT, (List)Lists.newArrayList(), MFR, HW, SW, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        DefaultDriver child = new DefaultDriver(CHILD, (List)Lists.newArrayList((Object[])new Driver[]{root}), MFR, HW, SW, (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)KEY, (Object)VALUE));
        DefaultDriver grandChild = new DefaultDriver(GRAND_CHILD, (List)Lists.newArrayList((Object[])new Driver[]{child}), MFR, HW, SW, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        Assert.assertNull((Object)root.getProperty(KEY));
        Assert.assertEquals((Object)VALUE, (Object)child.getProperty(KEY));
        Assert.assertEquals((Object)VALUE, (Object)grandChild.getProperty(KEY));
    }
}

