/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.pi.runtime.PiTableId;

public class PiTableIdTest {
    final String table10 = "table10";
    final String table20 = "table20";
    final PiTableId piTableId1 = PiTableId.of((String)"table10");
    final PiTableId sameAsPiTableId1 = PiTableId.of((String)"table10");
    final PiTableId piTableId2 = PiTableId.of((String)"table20");
    final String tableScope = "local";
    final PiTableId piTableIdWithScope1 = PiTableId.of((String)"local", (String)"table10");
    final PiTableId sameAsPiTableIdWithScope1 = PiTableId.of((String)"local", (String)"table10");
    final PiTableId piTableIdWithScope2 = PiTableId.of((String)"local", (String)"table20");

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiTableId.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piTableId1, this.sameAsPiTableId1}).addEqualityGroup(new Object[]{this.piTableId2}).testEquals();
    }

    @Test
    public void testEqualsWithScope() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piTableIdWithScope1, this.sameAsPiTableIdWithScope1}).addEqualityGroup(new Object[]{this.piTableIdWithScope2}).testEquals();
    }

    @Test
    public void testConstruction() {
        String name = "table1";
        PiTableId piTableId = PiTableId.of((String)"table1");
        MatcherAssert.assertThat((Object)piTableId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piTableId.name(), (Matcher)Matchers.is((Object)"table1"));
    }

    @Test
    public void testConstructionWithScope() {
        String name = "table1";
        String scope = "local";
        PiTableId piTableId = PiTableId.of((String)"local", (String)"table1");
        MatcherAssert.assertThat((Object)piTableId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piTableId.name(), (Matcher)Matchers.is((Object)"table1"));
        MatcherAssert.assertThat(piTableId.scope().get(), (Matcher)Matchers.is((Object)"local"));
    }
}

