/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.store.service.AtomicValueEvent;

public class AtomicValueEventTest {
    AtomicValueEvent<String> event1 = new AtomicValueEvent("map1", (Object)"e1", (Object)"e0");
    AtomicValueEvent<String> event2 = new AtomicValueEvent("map1", (Object)"e2", (Object)"e1");
    AtomicValueEvent<String> sameAsEvent2 = new AtomicValueEvent("map1", (Object)"e2", (Object)"e1");
    AtomicValueEvent<String> event3 = new AtomicValueEvent("map2", (Object)"e2", (Object)"e1");

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(AtomicValueEvent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2, this.sameAsEvent2}).addEqualityGroup(new Object[]{this.event3}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.event1.type(), (Matcher)Matchers.is((Object)AtomicValueEvent.Type.UPDATE));
        MatcherAssert.assertThat((Object)this.event1.newValue(), (Matcher)Matchers.is((Object)"e1"));
        MatcherAssert.assertThat((Object)this.event1.oldValue(), (Matcher)Matchers.is((Object)"e0"));
        MatcherAssert.assertThat((Object)this.event1.name(), (Matcher)Matchers.is((Object)"map1"));
    }
}

