/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.cluster.NodeId;

public class Leader {
    private final NodeId nodeId;
    private final long term;
    private final long termStartTime;

    public Leader(NodeId nodeId, long term, long termStartTime) {
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be non-negative");
        this.term = term;
        Preconditions.checkArgument((termStartTime >= 0L ? 1 : 0) != 0, (Object)"termStartTime must be non-negative");
        this.termStartTime = termStartTime;
    }

    public NodeId nodeId() {
        return this.nodeId;
    }

    public long term() {
        return this.term;
    }

    public long termStartTime() {
        return this.termStartTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && other instanceof Leader) {
            Leader that = (Leader)other;
            return Objects.equal((Object)this.nodeId, (Object)that.nodeId) && this.term == that.term && this.termStartTime == that.termStartTime;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeId, this.term, this.termStartTime});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("nodeId", (Object)this.nodeId).add("term", this.term).add("termStartTime", this.termStartTime).toString();
    }
}

