/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Version;
import org.onosproject.security.Permission;

public class DefaultApplication
implements Application {
    private final ApplicationId appId;
    private final Version version;
    private final String title;
    private final String description;
    private final String category;
    private final String url;
    private final String readme;
    private final byte[] icon;
    private final String origin;
    private final ApplicationRole role;
    private final Set<Permission> permissions;
    private final Optional<URI> featuresRepo;
    private final List<String> features;
    private final List<String> requiredApps;

    public DefaultApplication(ApplicationId appId, Version version, String title, String description, String origin, String category, String url, String readme, byte[] icon, ApplicationRole role, Set<Permission> permissions, Optional<URI> featuresRepo, List<String> features, List<String> requiredApps) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ID cannot be null");
        this.version = (Version)Preconditions.checkNotNull((Object)version, (Object)"Version cannot be null");
        this.title = (String)Preconditions.checkNotNull((Object)title, (Object)"Title cannot be null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"Description cannot be null");
        this.origin = (String)Preconditions.checkNotNull((Object)origin, (Object)"Origin cannot be null");
        this.category = (String)Preconditions.checkNotNull((Object)category, (Object)"Category cannot be null");
        this.url = url;
        this.readme = (String)Preconditions.checkNotNull((Object)readme, (Object)"Readme cannot be null");
        this.icon = icon == null ? new byte[]{} : (byte[])icon.clone();
        this.role = (ApplicationRole)((Object)Preconditions.checkNotNull((Object)((Object)role), (Object)"Role cannot be null"));
        this.permissions = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(permissions, (Object)"Permissions cannot be null")));
        this.featuresRepo = (Optional)Preconditions.checkNotNull(featuresRepo, (Object)"Features repo cannot be null");
        this.features = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(features, (Object)"Features cannot be null")));
        this.requiredApps = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(requiredApps, (Object)"Required apps cannot be null")));
        Preconditions.checkArgument((!features.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one feature");
    }

    @Override
    public ApplicationId id() {
        return this.appId;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String category() {
        return this.category;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String readme() {
        return this.readme;
    }

    @Override
    public byte[] icon() {
        return (byte[])this.icon.clone();
    }

    @Override
    public String origin() {
        return this.origin;
    }

    @Override
    public ApplicationRole role() {
        return this.role;
    }

    @Override
    public Set<Permission> permissions() {
        return this.permissions;
    }

    @Override
    public Optional<URI> featuresRepo() {
        return this.featuresRepo;
    }

    @Override
    public List<String> features() {
        return this.features;
    }

    @Override
    public List<String> requiredApps() {
        return this.requiredApps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appId, this.version, this.title, this.description, this.origin, this.category, this.url, this.readme, this.role, this.permissions, this.featuresRepo, this.features, this.requiredApps});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultApplication other = (DefaultApplication)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.version, other.version) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.origin, other.origin) && Objects.equals(this.category, other.category) && Objects.equals(this.url, other.url) && Objects.equals(this.readme, other.readme) && Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.featuresRepo, other.featuresRepo) && Objects.equals(this.features, other.features) && Objects.equals(this.requiredApps, other.requiredApps);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("version", (Object)this.version).add("title", (Object)this.title).add("description", (Object)this.description).add("origin", (Object)this.origin).add("category", (Object)this.category).add("url", (Object)this.url).add("readme", (Object)this.readme).add("role", (Object)this.role).add("permissions", this.permissions).add("featuresRepo", this.featuresRepo).add("features", this.features).add("requiredApps", this.requiredApps).toString();
    }
}

