/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;

public class DefaultEdgeLink
extends DefaultLink
implements EdgeLink {
    private final HostId hostId;
    private final HostLocation hostLocation;

    public DefaultEdgeLink(ProviderId providerId, ConnectPoint hostPoint, HostLocation hostLocation, boolean isIngress, Annotations ... annotations) {
        super(providerId, isIngress ? hostPoint : hostLocation, isIngress ? hostLocation : hostPoint, Link.Type.EDGE, Link.State.ACTIVE, annotations);
        Preconditions.checkArgument((boolean)(hostPoint.elementId() instanceof HostId), (Object)"Host point does not refer to a host ID");
        this.hostId = (HostId)hostPoint.elementId();
        this.hostLocation = hostLocation;
    }

    @Override
    public HostId hostId() {
        return this.hostId;
    }

    @Override
    public HostLocation hostLocation() {
        return this.hostLocation;
    }

    public static DefaultEdgeLink createEdgeLink(ConnectPoint edgePort, boolean isIngress) {
        Preconditions.checkNotNull((Object)edgePort, (Object)"Edge port cannot be null");
        HostLocation location = edgePort instanceof HostLocation ? (HostLocation)edgePort : new HostLocation(edgePort, 0L);
        return new DefaultEdgeLink(ProviderId.NONE, new ConnectPoint(HostId.NONE, PortNumber.P0), location, isIngress, new Annotations[0]);
    }

    public static DefaultEdgeLink createEdgeLink(Host host, boolean isIngress) {
        Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null");
        return new DefaultEdgeLink(ProviderId.NONE, new ConnectPoint(host.id(), PortNumber.P0), host.location(), isIngress, host.annotations());
    }
}

