/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.onlab.util.HexString;

public class OduSignalId {
    private final int tributaryPortNumber;
    private final int tributarySlotLength;
    private final byte[] tributarySlotBitmap;
    public static final int TRIBUTARY_SLOT_BITMAP_SIZE = 10;

    public OduSignalId(int tributaryPortNumber, int tributarySlotLen, byte[] tributarySlotBitmap) {
        Preconditions.checkArgument((tributaryPortNumber <= 80 ? 1 : 0) != 0, (String)"tributaryPortNumber %s must be <= 80 ", (int)tributaryPortNumber);
        Preconditions.checkArgument((tributarySlotBitmap.length == 10 ? 1 : 0) != 0, (Object)("number of elements in list " + HexString.toHexString((byte[])tributarySlotBitmap) + " must be equal to " + 10));
        Preconditions.checkArgument((tributarySlotLen <= 80 ? 1 : 0) != 0, (String)"tributarySlotLen %s must be <= 80 ", (int)tributarySlotLen);
        this.tributaryPortNumber = tributaryPortNumber;
        this.tributarySlotLength = tributarySlotLen;
        this.tributarySlotBitmap = Arrays.copyOf(tributarySlotBitmap, tributarySlotBitmap.length);
    }

    public static OduSignalId oduSignalId(int tributaryPortNumber, int tributarySlotLen, byte[] tributarySlotBitmap) {
        return new OduSignalId(tributaryPortNumber, tributarySlotLen, tributarySlotBitmap);
    }

    public int tributaryPortNumber() {
        return this.tributaryPortNumber;
    }

    public int tributarySlotLength() {
        return this.tributarySlotLength;
    }

    public byte[] tributarySlotBitmap() {
        return Arrays.copyOf(this.tributarySlotBitmap, this.tributarySlotBitmap.length);
    }

    public int hashCode() {
        return Objects.hash(this.tributaryPortNumber, this.tributarySlotLength, Arrays.hashCode(this.tributarySlotBitmap));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OduSignalId)) {
            return false;
        }
        OduSignalId other = (OduSignalId)obj;
        return Objects.equals(this.tributaryPortNumber, other.tributaryPortNumber) && Objects.equals(this.tributarySlotLength, other.tributarySlotLength) && Arrays.equals(this.tributarySlotBitmap, other.tributarySlotBitmap);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("tributaryPortNumber", this.tributaryPortNumber).add("tributarySlotLength", this.tributarySlotLength).add("tributarySlotBitmap", (Object)HexString.toHexString((byte[])this.tributarySlotBitmap)).toString();
    }
}

