/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Optional;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoint;
import org.onosproject.net.behaviour.TunnelKey;
import org.onosproject.net.behaviour.TunnelName;

public final class DefaultTunnelDescription
extends AbstractDescription
implements TunnelDescription {
    private final Optional<String> deviceId;
    private final String ifaceName;
    private final TunnelDescription.Type type;
    private final Optional<TunnelEndPoint> local;
    private final Optional<TunnelEndPoint> remote;
    private final Optional<TunnelKey> key;

    @Deprecated
    public DefaultTunnelDescription(TunnelEndPoint src, TunnelEndPoint dst, TunnelDescription.Type type, TunnelName tunnelName, SparseAnnotations ... annotations) {
        super(annotations);
        this.deviceId = Optional.empty();
        this.local = Optional.ofNullable(src);
        this.remote = Optional.ofNullable(dst);
        this.type = type;
        this.ifaceName = tunnelName.value();
        this.key = Optional.empty();
    }

    private DefaultTunnelDescription(Optional<String> deviceId, String ifaceName, TunnelDescription.Type type, Optional<TunnelEndPoint> local, Optional<TunnelEndPoint> remote, Optional<TunnelKey> key, SparseAnnotations ... annotations) {
        super(annotations);
        this.deviceId = deviceId;
        this.ifaceName = (String)Preconditions.checkNotNull((Object)ifaceName);
        this.type = type;
        this.local = local;
        this.remote = remote;
        this.key = key;
    }

    @Override
    public Optional<String> deviceId() {
        return this.deviceId;
    }

    @Override
    public String ifaceName() {
        return this.ifaceName;
    }

    @Override
    @Deprecated
    public TunnelEndPoint src() {
        return this.local.isPresent() ? this.local.get() : null;
    }

    @Override
    @Deprecated
    public TunnelEndPoint dst() {
        return this.remote.isPresent() ? this.remote.get() : null;
    }

    @Override
    public TunnelDescription.Type type() {
        return this.type;
    }

    @Override
    public Optional<TunnelEndPoint> local() {
        return this.local;
    }

    @Override
    public Optional<TunnelEndPoint> remote() {
        return this.remote;
    }

    @Override
    public Optional<TunnelKey> key() {
        return this.key;
    }

    @Override
    @Deprecated
    public TunnelName tunnelName() {
        return TunnelName.tunnelName(this.ifaceName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", this.deviceId).add("ifaceName", (Object)this.ifaceName).add("type", (Object)this.type).add("local", this.local).add("remote", this.remote).add("key", this.key).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements TunnelDescription.Builder {
        private Optional<String> deviceId = Optional.empty();
        private String ifaceName;
        private TunnelDescription.Type type;
        private Optional<TunnelEndPoint> local = Optional.empty();
        private Optional<TunnelEndPoint> remote = Optional.empty();
        private Optional<TunnelKey> key = Optional.empty();
        private Optional<SparseAnnotations> otherConfigs = Optional.empty();

        private Builder() {
        }

        @Override
        public TunnelDescription build() {
            if (this.otherConfigs.isPresent()) {
                return new DefaultTunnelDescription((Optional)this.deviceId, this.ifaceName, this.type, (Optional)this.local, (Optional)this.remote, (Optional)this.key, new SparseAnnotations[]{this.otherConfigs.get()});
            }
            return new DefaultTunnelDescription((Optional)this.deviceId, this.ifaceName, this.type, (Optional)this.local, (Optional)this.remote, (Optional)this.key, new SparseAnnotations[0]);
        }

        @Override
        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.ofNullable(deviceId);
            return this;
        }

        @Override
        public Builder ifaceName(String ifaceName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ifaceName) ? 1 : 0) != 0);
            this.ifaceName = ifaceName;
            return this;
        }

        @Override
        public Builder type(TunnelDescription.Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder local(TunnelEndPoint endpoint) {
            this.local = Optional.ofNullable(endpoint);
            return this;
        }

        @Override
        public Builder remote(TunnelEndPoint endpoint) {
            this.remote = Optional.ofNullable(endpoint);
            return this;
        }

        @Override
        public Builder key(TunnelKey key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        public Builder otherConfigs(SparseAnnotations configs) {
            this.otherConfigs = Optional.ofNullable(configs);
            return this;
        }
    }
}

