/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.List;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointDescription;
import org.onosproject.net.config.BaseConfig;
import org.onosproject.net.config.Config;

public class ProtectionConfig
extends BaseConfig<DeviceId> {
    public static final String CONFIG_KEY = "protection";
    private static final String PATHS = "paths";
    private static final String PEER = "peer";
    private static final String FINGERPRINT = "fingerprint";

    @Override
    public boolean isValid() {
        return this.isString(PEER, Config.FieldPresence.MANDATORY, new String[0]) && this.isString(FINGERPRINT, Config.FieldPresence.MANDATORY, new String[0]) && this.hasField(PATHS);
    }

    public List<TransportEndpointDescription> paths() {
        return this.getList(PATHS, jsonStr -> this.decode((String)jsonStr, TransportEndpointDescription.class));
    }

    public ProtectionConfig paths(List<TransportEndpointDescription> paths) {
        this.setList(PATHS, elm -> this.encode(elm, TransportEndpointDescription.class).toString(), paths);
        return this;
    }

    public DeviceId peer() {
        return DeviceId.deviceId(this.get(PEER, ""));
    }

    public ProtectionConfig peer(DeviceId peer) {
        this.setOrClear(PEER, peer.toString());
        return this;
    }

    public String fingerprint() {
        return this.get(FINGERPRINT, "");
    }

    public ProtectionConfig fingerprint(String fingerprint) {
        this.setOrClear(FINGERPRINT, (String)Preconditions.checkNotNull((Object)fingerprint));
        return this;
    }

    public ProtectedTransportEndpointDescription asDescription() {
        return ProtectedTransportEndpointDescription.buildDescription(this.paths(), this.peer(), this.fingerprint());
    }

    @Override
    public String toString() {
        return this.object.toString();
    }

    public ProtectionConfig() {
    }

    public ProtectionConfig(DeviceId did) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(did, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }
}

