/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;

public class DefaultObjectiveContext
implements ObjectiveContext {
    private final Consumer<Objective> onSuccess;
    private final BiConsumer<Objective, ObjectiveError> onError;

    public DefaultObjectiveContext(Consumer<Objective> onSuccess, BiConsumer<Objective, ObjectiveError> onError) {
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    public DefaultObjectiveContext(Consumer<Objective> onSuccess) {
        this(onSuccess, null);
    }

    public DefaultObjectiveContext(BiConsumer<Objective, ObjectiveError> onError) {
        this(null, onError);
    }

    @Override
    public void onSuccess(Objective objective) {
        if (this.onSuccess != null) {
            this.onSuccess.accept(objective);
        }
    }

    @Override
    public void onError(Objective objective, ObjectiveError error) {
        if (this.onError != null) {
            this.onError.accept(objective, error);
        }
    }
}

