/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import java.util.StringJoiner;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;

@Beta
public final class PiMatchKey {
    private final ImmutableMap<PiHeaderFieldId, PiFieldMatch> fieldMatches;

    private PiMatchKey(ImmutableMap<PiHeaderFieldId, PiFieldMatch> fieldMatches) {
        this.fieldMatches = fieldMatches;
    }

    public Collection<PiFieldMatch> fieldMatches() {
        return this.fieldMatches.values();
    }

    public Optional<PiFieldMatch> fieldMatch(PiHeaderFieldId fieldId) {
        return Optional.ofNullable(this.fieldMatches.get((Object)fieldId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiMatchKey)) {
            return false;
        }
        PiMatchKey that = (PiMatchKey)o;
        return Objects.equal(this.fieldMatches, that.fieldMatches);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldMatches});
    }

    public String toString() {
        StringJoiner stringFieldMatches = new StringJoiner(", ", "{", "}");
        this.fieldMatches.values().forEach(f -> stringFieldMatches.add(f.toString()));
        return stringFieldMatches.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<PiHeaderFieldId, PiFieldMatch> fieldMatchesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder addFieldMatch(PiFieldMatch fieldMatch) {
            this.fieldMatchesBuilder.put((Object)fieldMatch.fieldId(), (Object)fieldMatch);
            return this;
        }

        public Builder addFieldMatches(Collection<PiFieldMatch> fieldMatches) {
            fieldMatches.forEach(this::addFieldMatch);
            return this;
        }

        public PiMatchKey build() {
            ImmutableMap fieldMatches = this.fieldMatchesBuilder.build();
            Preconditions.checkArgument((fieldMatches.size() > 0 ? 1 : 0) != 0, (Object)"Field matches cannot be empty");
            return new PiMatchKey(fieldMatches);
        }
    }
}

