/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiPacketMetadata;
import org.onosproject.net.pi.runtime.PiPacketMetadataId;

@Beta
public final class PiPacketOperation {
    private final ImmutableByteSequence data;
    private final Set<PiPacketMetadata> packetMetadatas;
    private final Type type;

    private PiPacketOperation(ImmutableByteSequence data, Collection<PiPacketMetadata> packetMetadatas, Type type) {
        this.data = data;
        this.packetMetadatas = ImmutableSet.copyOf(packetMetadatas);
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public ImmutableByteSequence data() {
        return this.data;
    }

    public Collection<PiPacketMetadata> metadatas() {
        return this.packetMetadatas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiPacketOperation that = (PiPacketOperation)o;
        return Objects.equal(this.packetMetadatas, that.packetMetadatas) && Objects.equal((Object)this.data, (Object)that.data()) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type()));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.data, this.packetMetadatas, this.type});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.packetMetadatas).addValue((Object)this.type.toString()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<PiPacketMetadataId, PiPacketMetadata> packetMetadatas = new HashMap<PiPacketMetadataId, PiPacketMetadata>();
        private Type type;
        private ImmutableByteSequence data;

        private Builder() {
        }

        public Builder withData(ImmutableByteSequence data) {
            Preconditions.checkNotNull((Object)data);
            this.data = data;
            return this;
        }

        public Builder withMetadata(PiPacketMetadata metadata) {
            Preconditions.checkNotNull((Object)metadata);
            this.packetMetadatas.put(metadata.id(), metadata);
            return this;
        }

        public Builder withMetadatas(Collection<PiPacketMetadata> metadatas) {
            Preconditions.checkNotNull(metadatas);
            metadatas.forEach(this::withMetadata);
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public PiPacketOperation build() {
            Preconditions.checkNotNull((Object)this.data);
            Preconditions.checkNotNull(this.packetMetadatas);
            Preconditions.checkNotNull((Object)((Object)this.type));
            return new PiPacketOperation(this.data, this.packetMetadatas.values(), this.type);
        }
    }

    public static enum Type {
        PACKET_OUT,
        PACKET_IN;

    }
}

