/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDisjointPath;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.host.HostService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.AdapterLinkWeigher;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.HopCountLinkWeight;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;

public abstract class AbstractPathService
implements PathService {
    private static final String ELEMENT_ID_NULL = "Element ID cannot be null";
    private static final EdgeLink NOT_HOST = new NotHost();
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core");
    private static final PortNumber P0 = PortNumber.portNumber(0L);
    protected static final LinkWeigher DEFAULT_WEIGHER = AdapterLinkWeigher.adapt(new HopCountLinkWeight());
    protected TopologyService topologyService;
    protected HostService hostService;

    @Override
    public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
        return this.getPaths(src, dst, AdapterLinkWeigher.adapt(weight));
    }

    @Override
    public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        LinkWeigher internalWeigher = weigher != null ? weigher : DEFAULT_WEIGHER;
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePaths(srcEdge, dstEdge, internalWeigher);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<Path> paths = this.topologyService.getPaths(topology, srcDevice, dstDevice, internalWeigher);
        return this.edgeToEdgePaths(srcEdge, dstEdge, paths, internalWeigher);
    }

    @Override
    public Stream<Path> getKShortestPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        LinkWeigher internalWeigher = weigher != null ? weigher : DEFAULT_WEIGHER;
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return Stream.empty();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return Stream.of(this.edgeToEdgePath(srcEdge, dstEdge, null, internalWeigher));
        }
        Topology topology = this.topologyService.currentTopology();
        return this.topologyService.getKShortestPaths(topology, srcDevice, dstDevice, internalWeigher).map(path -> this.edgeToEdgePath(srcEdge, dstEdge, (Path)path, internalWeigher));
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight) {
        return this.getDisjointPaths(src, dst, AdapterLinkWeigher.adapt(weight));
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        LinkWeigher internalWeigher = weigher != null ? weigher : DEFAULT_WEIGHER;
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, internalWeigher);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<DisjointPath> paths = this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice, internalWeigher);
        return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, paths, internalWeigher);
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeight weight, Map<Link, Object> riskProfile) {
        return this.getDisjointPaths(src, dst, AdapterLinkWeigher.adapt(weight), riskProfile);
    }

    @Override
    public Set<DisjointPath> getDisjointPaths(ElementId src, ElementId dst, LinkWeigher weigher, Map<Link, Object> riskProfile) {
        DeviceId dstDevice;
        Preconditions.checkNotNull((Object)src, (Object)ELEMENT_ID_NULL);
        Preconditions.checkNotNull((Object)dst, (Object)ELEMENT_ID_NULL);
        LinkWeigher internalWeigher = weigher != null ? weigher : DEFAULT_WEIGHER;
        EdgeLink srcEdge = this.getEdgeLink(src, true);
        EdgeLink dstEdge = this.getEdgeLink(dst, false);
        if (srcEdge == null || dstEdge == null) {
            return ImmutableSet.of();
        }
        DeviceId srcDevice = srcEdge != NOT_HOST ? srcEdge.dst().deviceId() : (DeviceId)src;
        DeviceId deviceId = dstDevice = dstEdge != NOT_HOST ? dstEdge.src().deviceId() : (DeviceId)dst;
        if (srcDevice.equals(dstDevice)) {
            return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, internalWeigher);
        }
        Topology topology = this.topologyService.currentTopology();
        Set<DisjointPath> paths = this.topologyService.getDisjointPaths(topology, srcDevice, dstDevice, internalWeigher, riskProfile);
        return this.edgeToEdgePathsDisjoint(srcEdge, dstEdge, paths, internalWeigher);
    }

    private EdgeLink getEdgeLink(ElementId elementId, boolean isIngress) {
        if (elementId instanceof HostId) {
            Host host = this.hostService.getHost((HostId)elementId);
            if (host == null) {
                return null;
            }
            return new DefaultEdgeLink(PID, new ConnectPoint(elementId, P0), host.location(), isIngress, new Annotations[0]);
        }
        return NOT_HOST;
    }

    private Set<Path> edgeToEdgePaths(EdgeLink srcLink, EdgeLink dstLink, LinkWeigher weigher) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)1);
        endToEndPaths.add(this.edgeToEdgePath(srcLink, dstLink, null, weigher));
        return endToEndPaths;
    }

    private Set<Path> edgeToEdgePaths(EdgeLink srcLink, EdgeLink dstLink, Set<Path> paths, LinkWeigher weigher) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)paths.size());
        for (Path path : paths) {
            endToEndPaths.add(this.edgeToEdgePath(srcLink, dstLink, path, weigher));
        }
        return endToEndPaths;
    }

    private Set<DisjointPath> edgeToEdgePathsDisjoint(EdgeLink srcLink, EdgeLink dstLink, LinkWeigher weigher) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)1);
        endToEndPaths.add(this.edgeToEdgePathD(srcLink, dstLink, null, weigher));
        return endToEndPaths;
    }

    private Set<DisjointPath> edgeToEdgePathsDisjoint(EdgeLink srcLink, EdgeLink dstLink, Set<DisjointPath> paths, LinkWeigher weigher) {
        HashSet endToEndPaths = Sets.newHashSetWithExpectedSize((int)paths.size());
        for (DisjointPath path : paths) {
            endToEndPaths.add(this.edgeToEdgePathD(srcLink, dstLink, path, weigher));
        }
        return endToEndPaths;
    }

    private Path edgeToEdgePath(EdgeLink srcLink, EdgeLink dstLink, Path path, LinkWeigher weigher) {
        ArrayList links = Lists.newArrayListWithCapacity((int)2);
        Weight cost = weigher.getInitialWeight();
        if (srcLink != NOT_HOST) {
            links.add(srcLink);
            cost = cost.merge(weigher.weight(new DefaultTopologyEdge(null, null, srcLink)));
        }
        if (path != null) {
            links.addAll(path.links());
            cost = cost.merge(path.weight());
        }
        if (dstLink != NOT_HOST) {
            links.add(dstLink);
            cost = cost.merge(weigher.weight(new DefaultTopologyEdge(null, null, dstLink)));
        }
        return new DefaultPath(PID, (List<Link>)links, cost, new Annotations[0]);
    }

    private DisjointPath edgeToEdgePathD(EdgeLink srcLink, EdgeLink dstLink, DisjointPath path, LinkWeigher weigher) {
        Path primary = null;
        Path backup = null;
        if (path != null) {
            primary = path.primary();
            backup = path.backup();
        }
        if (backup == null) {
            return new DefaultDisjointPath(PID, (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, primary, weigher));
        }
        return new DefaultDisjointPath(PID, (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, primary, weigher), (DefaultPath)this.edgeToEdgePath(srcLink, dstLink, backup, weigher));
    }

    private static class NotHost
    extends DefaultEdgeLink
    implements EdgeLink {
        NotHost() {
            super(PID, new ConnectPoint(HostId.NONE, P0), new HostLocation(DeviceId.NONE, P0, 0L), false, new Annotations[0]);
        }
    }
}

