/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security;

import com.google.common.annotations.Beta;
import java.security.BasicPermission;

@Beta
public class AppPermission
extends BasicPermission {
    protected Type type;

    public AppPermission(String name) {
        super(name.toUpperCase(), "");
        try {
            this.type = Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            this.type = null;
        }
    }

    public AppPermission(String name, String actions) {
        super(name.toUpperCase(), actions);
        try {
            this.type = Type.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            this.type = null;
        }
    }

    public AppPermission(Type type) {
        super(type.name(), "");
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        APP_READ,
        APP_EVENT,
        APP_WRITE,
        CONFIG_READ,
        CONFIG_WRITE,
        CONFIG_EVENT,
        CLUSTER_READ,
        CLUSTER_WRITE,
        CLUSTER_EVENT,
        CODEC_READ,
        CODEC_WRITE,
        CLOCK_WRITE,
        DEVICE_KEY_EVENT,
        DEVICE_KEY_READ,
        DEVICE_KEY_WRITE,
        DEVICE_READ,
        DEVICE_EVENT,
        DRIVER_READ,
        DRIVER_WRITE,
        EVENT_READ,
        EVENT_WRITE,
        FLOWRULE_READ,
        FLOWRULE_WRITE,
        FLOWRULE_EVENT,
        GROUP_READ,
        GROUP_WRITE,
        GROUP_EVENT,
        HOST_READ,
        HOST_WRITE,
        HOST_EVENT,
        INTENT_READ,
        INTENT_WRITE,
        INTENT_EVENT,
        LINK_READ,
        LINK_WRITE,
        LINK_EVENT,
        MUTEX_WRITE,
        PACKET_READ,
        PACKET_WRITE,
        PACKET_EVENT,
        PERSISTENCE_WRITE,
        PARTITION_READ,
        PARTITION_EVENT,
        RESOURCE_READ,
        RESOURCE_WRITE,
        RESOURCE_EVENT,
        REGION_READ,
        STATISTIC_READ,
        STORAGE_WRITE,
        TOPOLOGY_READ,
        TOPOLOGY_EVENT,
        TUNNEL_READ,
        TUNNEL_WRITE,
        TUNNEL_EVENT,
        UI_READ,
        UI_WRITE;

    }
}

