/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import org.onosproject.core.ApplicationId;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Serializer;

public abstract class DistributedPrimitiveBuilder<B extends DistributedPrimitiveBuilder<B, T>, T extends DistributedPrimitive> {
    private final DistributedPrimitive.Type type;
    private String name;
    private ApplicationId applicationId;
    private Serializer serializer;
    private boolean partitionsDisabled = false;
    private boolean meteringDisabled = false;
    private boolean readOnly = false;
    private boolean relaxedReadConsistency = false;

    public DistributedPrimitiveBuilder(DistributedPrimitive.Type type) {
        this.type = type;
    }

    public B withName(String name) {
        this.name = name;
        return (B)this;
    }

    public B withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return (B)this;
    }

    public B withApplicationId(ApplicationId applicationId) {
        this.applicationId = applicationId;
        return (B)this;
    }

    @Deprecated
    public B withMeteringDisabled() {
        this.meteringDisabled = true;
        return (B)this;
    }

    public B withUpdatesDisabled() {
        this.readOnly = true;
        return (B)this;
    }

    public B withRelaxedReadConsistency() {
        this.relaxedReadConsistency = true;
        return (B)this;
    }

    public final boolean meteringEnabled() {
        return !this.meteringDisabled;
    }

    public final boolean partitionsDisabled() {
        return this.partitionsDisabled;
    }

    public final boolean readOnly() {
        return this.readOnly;
    }

    public final boolean relaxedReadConsistency() {
        return this.relaxedReadConsistency;
    }

    public final Serializer serializer() {
        return this.serializer;
    }

    public final ApplicationId applicationId() {
        return this.applicationId;
    }

    public final String name() {
        return this.name;
    }

    public final DistributedPrimitive.Type type() {
        return this.type;
    }

    public abstract T build();
}

