/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultDistributedSet;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.SetEventListener;

public interface AsyncDistributedSet<E>
extends DistributedPrimitive {
    @Override
    default public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.SET;
    }

    public CompletableFuture<Void> addListener(SetEventListener<E> var1);

    public CompletableFuture<Void> removeListener(SetEventListener<E> var1);

    public CompletableFuture<Boolean> add(E var1);

    public CompletableFuture<Boolean> remove(E var1);

    public CompletableFuture<Integer> size();

    public CompletableFuture<Boolean> isEmpty();

    public CompletableFuture<Void> clear();

    public CompletableFuture<Boolean> contains(E var1);

    public CompletableFuture<Boolean> addAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> containsAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> retainAll(Collection<? extends E> var1);

    public CompletableFuture<Boolean> removeAll(Collection<? extends E> var1);

    default public DistributedSet<E> asDistributedSet() {
        return this.asDistributedSet(5000L);
    }

    default public DistributedSet<E> asDistributedSet(long timeoutMillis) {
        return new DefaultDistributedSet(this, timeoutMillis);
    }

    public CompletableFuture<? extends Set<E>> getAsImmutableSet();
}

