/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.lion;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LionBundle {
    private final String id;
    private final Set<LionItem> items;
    private final Map<String, String> mapped;

    private LionBundle(String id, Set<LionItem> items) {
        this.id = id;
        this.items = ImmutableSortedSet.copyOf(items);
        this.mapped = this.createLookup();
    }

    private Map<String, String> createLookup() {
        HashMap<String, String> lookup = new HashMap<String, String>(this.items.size());
        for (LionItem item : this.items) {
            lookup.put(item.key(), item.value());
        }
        return ImmutableSortedMap.copyOf(lookup);
    }

    public String id() {
        return this.id;
    }

    public int size() {
        return this.items.size();
    }

    public String toString() {
        return "LionBundle{id=" + this.id + ", #items=" + this.size() + "}";
    }

    public String getValue(String key) {
        return this.mapped.get(key);
    }

    public String getSafe(String key) {
        String value = this.mapped.get(key);
        return value == null ? "%" + key + "%" : value;
    }

    public Set<LionItem> getItems() {
        return this.items;
    }

    public String dump() {
        return this.mapped.toString();
    }

    public static final class LionItem
    implements Comparable<LionItem> {
        private final String key;
        private final String value;

        private LionItem(String key, String value) {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)value);
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "LionItem{key=" + this.key + ", value=\"" + this.value + "\"}";
        }

        @Override
        public int compareTo(LionItem o) {
            return this.key.compareTo(o.key);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class Builder {
        private final String id;
        private final Set<LionItem> items = new HashSet<LionItem>();

        public Builder(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public Builder addItem(String key, String value) {
            this.items.add(new LionItem(key, value));
            return this;
        }

        public LionBundle build() {
            return new LionBundle(this.id, this.items);
        }
    }
}

