/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.app.DefaultApplicationDescriptionTest;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.security.AppPermission;
import org.onosproject.security.Permission;

public class DefaultApplicationTest {
    public static final ApplicationId APP_ID = new DefaultApplicationId(2, "org.foo.app");
    private static final byte[] ICON_ORIG = new byte[]{1, 2, 3, 4};
    private static final Permission PERM_W = new Permission(AppPermission.class.getName(), "FLOWRULE_WRITE");
    private static final Permission PERM_R = new Permission(AppPermission.class.getName(), "FLOWRULE_READ");
    private static final Permission JUNK_PERM = new Permission("foo", "bar");
    private static final Set<Permission> PERMS_ORIG = ImmutableSet.of((Object)PERM_W, (Object)PERM_R);
    private static final Set<Permission> PERMS_UNSAFE = new HashSet<Permission>(PERMS_ORIG);
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String FIFI = "fifi";
    private static final String EVIL = "Bwahahahaha!";
    private static final List<String> FEATURES_ORIG = ImmutableList.of((Object)"foo", (Object)"bar");
    private static final List<String> FEATURES_UNSAFE = new ArrayList<String>(FEATURES_ORIG);
    private static final List<String> REQ_APPS_ORIG = ImmutableList.of((Object)"fifi");
    private static final List<String> REQ_APPS_UNSAFE = new ArrayList<String>(REQ_APPS_ORIG);

    @Test
    public void basics() {
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        Assert.assertEquals((String)"incorrect id", (Object)APP_ID, (Object)app.id());
        Assert.assertEquals((String)"incorrect version", (Object)DefaultApplicationDescriptionTest.VER, (Object)app.version());
        Assert.assertEquals((String)"incorrect title", (Object)"Awesome App", (Object)app.title());
        Assert.assertEquals((String)"incorrect description", (Object)"Awesome application from Circus, Inc.", (Object)app.description());
        Assert.assertEquals((String)"incorrect origin", (Object)"Circus", (Object)app.origin());
        Assert.assertEquals((String)"incorrect category", (Object)"other", (Object)app.category());
        Assert.assertEquals((String)"incorrect URL", (Object)"http://www.onosproject.org", (Object)app.url());
        Assert.assertEquals((String)"incorrect readme", (Object)"Awesome application from Circus, Inc.", (Object)app.readme());
        Assert.assertArrayEquals((String)"incorrect icon", (byte[])DefaultApplicationDescriptionTest.ICON, (byte[])app.icon());
        Assert.assertEquals((String)"incorrect role", (Object)DefaultApplicationDescriptionTest.ROLE, (Object)app.role());
        Assert.assertEquals((String)"incorrect permissions", DefaultApplicationDescriptionTest.PERMS, (Object)app.permissions());
        Assert.assertEquals((String)"incorrect features repo", (Object)DefaultApplicationDescriptionTest.FURL, app.featuresRepo().get());
        Assert.assertEquals((String)"incorrect features", DefaultApplicationDescriptionTest.FEATURES, (Object)app.features());
        Assert.assertEquals((String)"incorrect apps", DefaultApplicationDescriptionTest.APPS, (Object)app.requiredApps());
        Assert.assertTrue((String)"incorrect toString", (boolean)app.toString().contains("org.foo.app"));
    }

    @Test
    public void testEquality() {
        DefaultApplication a1 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        DefaultApplication a2 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        DefaultApplication a3 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.empty(), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        DefaultApplication a4 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circusasd", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        new EqualsTester().addEqualityGroup(new Object[]{a1, a2}).addEqualityGroup(new Object[]{a3}).addEqualityGroup(new Object[]{a4}).testEquals();
    }

    @Test
    public void immutableIcon() {
        int i;
        byte[] iconSourceData = (byte[])ICON_ORIG.clone();
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", iconSourceData, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        byte[] icon = app.icon();
        Assert.assertArrayEquals((String)"did not start with orig icon", (byte[])ICON_ORIG, (byte[])icon);
        int n = ICON_ORIG.length;
        for (i = 0; i < n; ++i) {
            icon[i] = 0;
        }
        Assert.assertArrayEquals((String)"no longer orig icon", (byte[])ICON_ORIG, (byte[])app.icon());
        n = ICON_ORIG.length;
        for (i = 0; i < n; ++i) {
            iconSourceData[i] = 0;
        }
        Assert.assertArrayEquals((String)"modifying source alters appicon", (byte[])ICON_ORIG, (byte[])app.icon());
    }

    @Test
    public void immutablePermissions() {
        Set<Permission> p = PERMS_UNSAFE;
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, p, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        Set perms = app.permissions();
        try {
            perms.add(JUNK_PERM);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"no write perm", (boolean)app.permissions().contains(PERM_W));
        Assert.assertTrue((String)"no read perm", (boolean)app.permissions().contains(PERM_R));
        Assert.assertEquals((String)"extra perms", (long)2L, (long)app.permissions().size());
    }

    @Test
    public void immutableFeatures() {
        List<String> f = FEATURES_UNSAFE;
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), f, DefaultApplicationDescriptionTest.APPS);
        List features = app.features();
        try {
            features.add(EVIL);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"no foo feature", (boolean)features.contains(FOO));
        Assert.assertTrue((String)"no bar feature", (boolean)features.contains(BAR));
        Assert.assertEquals((String)"extra features!", (long)2L, (long)features.size());
    }

    @Test
    public void immutableRequiredApps() {
        List<String> ra = REQ_APPS_UNSAFE;
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", DefaultApplicationDescriptionTest.ICON, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, ra);
        List reqApps = app.requiredApps();
        try {
            reqApps.add(EVIL);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"no fifi required app", (boolean)reqApps.contains(FIFI));
        Assert.assertEquals((String)"extra required apps!", (long)1L, (long)reqApps.size());
    }

    @Test
    public void nullIcon() {
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome App", "Awesome application from Circus, Inc.", "Circus", "other", "http://www.onosproject.org", "Awesome application from Circus, Inc.", null, DefaultApplicationDescriptionTest.ROLE, DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES, DefaultApplicationDescriptionTest.APPS);
        byte[] icon = app.icon();
        Assert.assertNotNull((String)"null icon", (Object)icon);
        Assert.assertEquals((String)"unexpected size", (long)0L, (long)icon.length);
    }
}

