/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PiCriterion;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiRangeFieldMatch;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;
import org.onosproject.net.pi.runtime.PiValidFieldMatch;

public class PiCriteriaTest {
    PiHeaderFieldId piEthHeaderFieldId = PiHeaderFieldId.of((String)"ethernet_t", (String)"etherType");
    byte[] matchExactBytes1 = new byte[]{8, 0};
    byte[] matchExactBytes2 = new byte[]{8, 6};
    Criterion matchPiExactByte1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactBytes1).build();
    Criterion sameAsMatchPiExactByte1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactBytes1).build();
    Criterion matchPiExactByte2 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactBytes2).build();
    short matchExactShort1 = (short)2048;
    short matchExactShort2 = (short)2054;
    Criterion matchPiExactShort1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactShort1).build();
    Criterion sameAsMatchPiExactShort1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactShort1).build();
    Criterion matchPiExactShort2 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactShort2).build();
    int matchExactInt1 = 2048;
    int matchExactInt2 = 2054;
    Criterion matchPiExactInt1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactInt1).build();
    Criterion sameAsMatchPiExactInt1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactInt1).build();
    Criterion matchPiExactInt2 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactInt2).build();
    long matchExactLong1 = 2048L;
    long matchExactLong2 = 2054L;
    Criterion matchPiExactLong1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactLong1).build();
    Criterion sameAsMatchPiExactLong1 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactLong1).build();
    Criterion matchPiExactLong2 = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactLong2).build();
    PiHeaderFieldId piIpv4HeaderFieldId = PiHeaderFieldId.of((String)"ipv4_t", (String)"dstAddr");
    int mask = 0xFFFFFF;
    byte[] matchLpmBytes1 = new byte[]{10, 1, 1, 1};
    byte[] matchLpmBytes2 = new byte[]{10, 1, 1, 2};
    Criterion matchPiLpmByte1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmBytes1, this.mask).build();
    Criterion sameAsMatchPiLpmByte1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmBytes1, this.mask).build();
    Criterion matchPiLpmByte2 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmBytes2, this.mask).build();
    short matchLpmShort1 = (short)2570;
    short matchLpmShort2 = (short)2571;
    Criterion matchPiLpmShort1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmShort1, this.mask).build();
    Criterion sameAsMatchPiLpmShort1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmShort1, this.mask).build();
    Criterion matchPiLpmShort2 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmShort2, this.mask).build();
    int matchLpmInt1 = 0xA010101;
    int matchLpmInt2 = 167837954;
    Criterion matchPiLpmInt1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmInt1, this.mask).build();
    Criterion sameAsMatchPiLpmInt1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmInt1, this.mask).build();
    Criterion matchPiLpmInt2 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmInt2, this.mask).build();
    long matchLpmLong1 = 0xA010101L;
    long matchLpmLong2 = 167837954L;
    Criterion matchPiLpmLong1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmLong1, this.mask).build();
    Criterion sameAsMatchPiLpmLong1 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmLong1, this.mask).build();
    Criterion matchPiLpmLong2 = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmLong2, this.mask).build();
    byte[] matchTernaryBytes1 = new byte[]{10, 1, 1, 1};
    byte[] matchTernaryBytes2 = new byte[]{10, 1, 1, 2};
    byte[] matchTernaryMaskBytes = new byte[]{127, 127, 127, 0};
    Criterion matchPiTernaryByte1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
    Criterion sameAsMatchPiTernaryByte1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
    Criterion matchPiTernaryByte2 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryBytes2, this.matchTernaryMaskBytes).build();
    short matchTernaryShort1 = (short)2570;
    short matchTernaryShort2 = (short)2571;
    short matchTernaryMaskShort = (short)4080;
    Criterion matchPiTernaryShort1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
    Criterion sameAsMatchPiTernaryShort1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
    Criterion matchPiTernaryShort2 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryShort2, this.matchTernaryMaskShort).build();
    int matchTernaryInt1 = 0xA010101;
    int matchTernaryInt2 = 167837954;
    int matchTernaryMaskInt = 65535;
    Criterion matchPiTernaryInt1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
    Criterion sameAsMatchPiTernaryInt1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
    Criterion matchPiTernaryInt2 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryInt2, this.matchTernaryMaskInt).build();
    long matchTernaryLong1 = 0xA010101L;
    long matchTernaryLong2 = 167837954L;
    long matchTernaryMaskLong = 65535L;
    Criterion matchPiTernaryLong1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
    Criterion sameAsMatchPiTernaryLong1 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
    Criterion matchPiTernaryLong2 = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryLong2, this.matchTernaryMaskLong).build();
    Criterion matchPiValid1 = PiCriterion.builder().matchValid(this.piIpv4HeaderFieldId, false).build();
    Criterion sameAsMatchPiValid1 = PiCriterion.builder().matchValid(this.piIpv4HeaderFieldId, false).build();
    Criterion matchPiValid2 = PiCriterion.builder().matchValid(this.piIpv4HeaderFieldId, true).build();
    byte[] matchRangeBytes1 = new byte[]{16};
    byte[] matchRangeBytes2 = new byte[]{32};
    byte[] matchRangeHighBytes = new byte[]{48};
    Criterion matchPiRangeByte1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
    Criterion sameAsMatchPiRangeByte1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
    Criterion matchPiRangeByte2 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeBytes2, this.matchRangeHighBytes).build();
    short matchRangeShort1 = (short)256;
    short matchRangeShort2 = (short)512;
    short matchRangeHighShort = (short)768;
    Criterion matchPiRangeShort1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
    Criterion sameAsMatchPiRangeShort1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
    Criterion matchPiRangeShort2 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeShort2, this.matchRangeHighShort).build();
    int matchRangeInt1 = 256;
    int matchRangeInt2 = 512;
    int matchRangeHighInt = 768;
    Criterion matchPiRangeInt1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
    Criterion sameAsMatchPiRangeInt1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
    Criterion matchPiRangeInt2 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeInt2, this.matchRangeHighInt).build();
    long matchRangeLong1 = 256L;
    long matchRangeLong2 = 512L;
    long matchRangeHighLong = 768L;
    Criterion matchPiRangeLong1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
    Criterion sameAsMatchPiRangeLong1 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
    Criterion matchPiRangeLong2 = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeLong2, this.matchRangeHighLong).build();

    private <T> T checkAndConvert(Criterion criterion, Criterion.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)criterion.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)criterion;
    }

    @Test
    public void testExactMatchPiMethod() {
        Criterion matchPiBytes = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactBytes1).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert(matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchBytes = new PiExactFieldMatch(this.piEthHeaderFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchExactBytes1));
        MatcherAssert.assertThat(piCriterionBytes.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchBytes));
        Criterion matchPiShort = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactShort1).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert(matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchShort = new PiExactFieldMatch(this.piEthHeaderFieldId, ImmutableByteSequence.copyFrom((short)this.matchExactShort1));
        MatcherAssert.assertThat(piCriterionShort.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchShort));
        Criterion matchPiInt = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactInt1).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert(matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchInt = new PiExactFieldMatch(this.piEthHeaderFieldId, ImmutableByteSequence.copyFrom((int)this.matchExactInt1));
        MatcherAssert.assertThat(piCriterionInt.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchInt));
        Criterion matchPiLong = PiCriterion.builder().matchExact(this.piEthHeaderFieldId, this.matchExactLong1).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert(matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiExactFieldMatch expectedMatchLong = new PiExactFieldMatch(this.piEthHeaderFieldId, ImmutableByteSequence.copyFrom((long)this.matchExactLong1));
        MatcherAssert.assertThat(piCriterionLong.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testLpmMatchPiMethod() {
        Criterion matchPiBytes = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmBytes1, this.mask).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert(matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchBytes = new PiLpmFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchLpmBytes1), this.mask);
        MatcherAssert.assertThat(piCriterionBytes.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchBytes));
        Criterion matchPiShort = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmShort1, this.mask).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert(matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchShort = new PiLpmFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((short)this.matchLpmShort1), this.mask);
        MatcherAssert.assertThat(piCriterionShort.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchShort));
        Criterion matchPiInt = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmInt1, this.mask).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert(matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchInt = new PiLpmFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((int)this.matchLpmInt1), this.mask);
        MatcherAssert.assertThat(piCriterionInt.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchInt));
        Criterion matchPiLong = PiCriterion.builder().matchLpm(this.piIpv4HeaderFieldId, this.matchLpmLong1, this.mask).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert(matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiLpmFieldMatch expectedMatchLong = new PiLpmFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((long)this.matchLpmLong1), this.mask);
        MatcherAssert.assertThat(piCriterionLong.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testTernaryMatchPiMethod() {
        Criterion matchPiBytes = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryBytes1, this.matchTernaryMaskBytes).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert(matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchBytes = new PiTernaryFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchTernaryBytes1), ImmutableByteSequence.copyFrom((byte[])this.matchTernaryMaskBytes));
        MatcherAssert.assertThat(piCriterionBytes.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchBytes));
        Criterion matchPiShort = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryShort1, this.matchTernaryMaskShort).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert(matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchShort = new PiTernaryFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((short)this.matchTernaryShort1), ImmutableByteSequence.copyFrom((short)this.matchTernaryMaskShort));
        MatcherAssert.assertThat(piCriterionShort.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchShort));
        Criterion matchPiInt = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryInt1, this.matchTernaryMaskInt).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert(matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchInt = new PiTernaryFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((int)this.matchTernaryInt1), ImmutableByteSequence.copyFrom((int)this.matchTernaryMaskInt));
        MatcherAssert.assertThat(piCriterionInt.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchInt));
        Criterion matchPiLong = PiCriterion.builder().matchTernary(this.piIpv4HeaderFieldId, this.matchTernaryLong1, this.matchTernaryMaskLong).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert(matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiTernaryFieldMatch expectedMatchLong = new PiTernaryFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((long)this.matchTernaryLong1), ImmutableByteSequence.copyFrom((long)this.matchTernaryMaskLong));
        MatcherAssert.assertThat(piCriterionLong.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testValidMatchPiMethod() {
        Criterion matchPiBytes = PiCriterion.builder().matchValid(this.piIpv4HeaderFieldId, true).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert(matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiValidFieldMatch expectedMatch = new PiValidFieldMatch(this.piIpv4HeaderFieldId, true);
        MatcherAssert.assertThat(piCriterionBytes.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatch));
    }

    @Test
    public void testRangeMatchPiMethod() {
        Criterion matchPiBytes = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeBytes1, this.matchRangeHighBytes).build();
        PiCriterion piCriterionBytes = (PiCriterion)this.checkAndConvert(matchPiBytes, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchBytes = new PiRangeFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((byte[])this.matchRangeBytes1), ImmutableByteSequence.copyFrom((byte[])this.matchRangeHighBytes));
        MatcherAssert.assertThat(piCriterionBytes.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchBytes));
        Criterion matchPiShort = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeShort1, this.matchRangeHighShort).build();
        PiCriterion piCriterionShort = (PiCriterion)this.checkAndConvert(matchPiShort, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchShort = new PiRangeFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((short)this.matchRangeShort1), ImmutableByteSequence.copyFrom((short)this.matchRangeHighShort));
        MatcherAssert.assertThat(piCriterionShort.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchShort));
        Criterion matchPiInt = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeInt1, this.matchRangeHighInt).build();
        PiCriterion piCriterionInt = (PiCriterion)this.checkAndConvert(matchPiInt, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchInt = new PiRangeFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((int)this.matchRangeInt1), ImmutableByteSequence.copyFrom((int)this.matchRangeHighInt));
        MatcherAssert.assertThat(piCriterionInt.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchInt));
        Criterion matchPiLong = PiCriterion.builder().matchRange(this.piIpv4HeaderFieldId, this.matchRangeLong1, this.matchRangeHighLong).build();
        PiCriterion piCriterionLong = (PiCriterion)this.checkAndConvert(matchPiLong, Criterion.Type.PROTOCOL_INDEPENDENT, PiCriterion.class);
        PiRangeFieldMatch expectedMatchLong = new PiRangeFieldMatch(this.piIpv4HeaderFieldId, ImmutableByteSequence.copyFrom((long)this.matchRangeLong1), ImmutableByteSequence.copyFrom((long)this.matchRangeHighLong));
        MatcherAssert.assertThat(piCriterionLong.fieldMatches().iterator().next(), (Matcher)Matchers.is((Object)expectedMatchLong));
    }

    @Test
    public void testPiExactCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactByte1, this.sameAsMatchPiExactByte1}).addEqualityGroup(new Object[]{this.matchPiExactByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactShort1, this.sameAsMatchPiExactShort1}).addEqualityGroup(new Object[]{this.matchPiExactShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactInt1, this.sameAsMatchPiExactInt1}).addEqualityGroup(new Object[]{this.matchPiExactInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiExactLong1, this.sameAsMatchPiExactLong1}).addEqualityGroup(new Object[]{this.matchPiExactLong2}).testEquals();
    }

    @Test
    public void testPiLpmCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmByte1, this.sameAsMatchPiLpmByte1}).addEqualityGroup(new Object[]{this.matchPiLpmByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmShort1, this.sameAsMatchPiLpmShort1}).addEqualityGroup(new Object[]{this.matchPiLpmShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmInt1, this.sameAsMatchPiLpmInt1}).addEqualityGroup(new Object[]{this.matchPiLpmInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiLpmLong1, this.sameAsMatchPiLpmLong1}).addEqualityGroup(new Object[]{this.matchPiLpmLong2}).testEquals();
    }

    @Test
    public void testPiTernaryCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryByte1, this.sameAsMatchPiTernaryByte1}).addEqualityGroup(new Object[]{this.matchPiTernaryByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryShort1, this.sameAsMatchPiTernaryShort1}).addEqualityGroup(new Object[]{this.matchPiTernaryShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryInt1, this.sameAsMatchPiTernaryInt1}).addEqualityGroup(new Object[]{this.matchPiTernaryInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiTernaryLong1, this.sameAsMatchPiTernaryLong1}).addEqualityGroup(new Object[]{this.matchPiTernaryLong2}).testEquals();
    }

    @Test
    public void testPiValidCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiValid1, this.sameAsMatchPiValid1}).addEqualityGroup(new Object[]{this.matchPiValid2}).testEquals();
    }

    @Test
    public void testPiRangeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeByte1, this.sameAsMatchPiRangeByte1}).addEqualityGroup(new Object[]{this.matchPiRangeByte2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeShort1, this.sameAsMatchPiRangeShort1}).addEqualityGroup(new Object[]{this.matchPiRangeShort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeInt1, this.sameAsMatchPiRangeInt1}).addEqualityGroup(new Object[]{this.matchPiRangeInt2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPiRangeLong1, this.sameAsMatchPiRangeLong1}).addEqualityGroup(new Object[]{this.matchPiRangeLong2}).testEquals();
    }
}

