/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.intent.IntentId;

public class IntentIdTest {
    @Test
    public void intentIdFollowsGuidelineForImmutableObject() {
        ImmutableClassChecker.assertThatClassIsImmutable(IntentId.class);
    }

    @Test
    public void testEquality() {
        IntentId id1 = new IntentId(1L);
        IntentId id2 = new IntentId(1L);
        Assert.assertThat((Object)id1, (Matcher)Matchers.is((Object)id2));
    }

    @Test
    public void testNonEquality() {
        IntentId id1 = new IntentId(1L);
        IntentId id2 = new IntentId(2L);
        Assert.assertThat((Object)id1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)id2)));
    }

    @Test
    public void valueOf() {
        IntentId id = new IntentId(3735928559L);
        Assert.assertEquals((String)"incorrect valueOf", (Object)id, (Object)IntentId.valueOf((long)3735928559L));
    }

    @Test
    public void testEquals() {
        IntentId id1 = new IntentId(11111L);
        IntentId sameAsId1 = new IntentId(11111L);
        IntentId id2 = new IntentId(22222L);
        new EqualsTester().addEqualityGroup(new Object[]{id1, sameAsId1}).addEqualityGroup(new Object[]{id2}).testEquals();
    }

    @Test
    public void testConstruction() {
        IntentId id1 = new IntentId(987654321L);
        Assert.assertEquals((long)id1.fingerprint(), (long)987654321L);
        IntentId emptyId = new IntentId();
        Assert.assertEquals((long)emptyId.fingerprint(), (long)0L);
    }
}

