/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import org.onosproject.net.pi.runtime.PiActionId;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiActionParamId;
import org.onosproject.net.pi.runtime.PiTableAction;

@Beta
public final class PiAction
implements PiTableAction {
    private final PiActionId actionId;
    private final Map<PiActionParamId, PiActionParam> runtimeParams;

    private PiAction(PiActionId actionId, Map<PiActionParamId, PiActionParam> runtimeParams) {
        this.actionId = actionId;
        this.runtimeParams = ImmutableMap.copyOf(runtimeParams);
    }

    @Override
    public PiTableAction.Type type() {
        return PiTableAction.Type.ACTION;
    }

    public PiActionId id() {
        return this.actionId;
    }

    public Collection<PiActionParam> parameters() {
        return this.runtimeParams.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiAction piAction = (PiAction)o;
        return Objects.equal((Object)((Object)this.actionId), (Object)((Object)piAction.actionId)) && Objects.equal(this.runtimeParams, piAction.runtimeParams);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actionId, this.runtimeParams});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ", "(", ")");
        this.parameters().forEach(p -> stringParams.add(p.toString()));
        return MoreObjects.toStringHelper((Object)this).addValue((Object)(this.id().toString() + stringParams.toString())).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiActionId actionId;
        private Map<PiActionParamId, PiActionParam> runtimeParams = Maps.newHashMap();

        private Builder() {
        }

        public Builder withId(PiActionId actionId) {
            this.actionId = actionId;
            return this;
        }

        public Builder withParameter(PiActionParam param) {
            Preconditions.checkNotNull((Object)param);
            this.runtimeParams.put(param.id(), param);
            return this;
        }

        public Builder withParameters(Collection<PiActionParam> params) {
            Preconditions.checkNotNull(params);
            params.forEach(this::withParameter);
            return this;
        }

        public PiAction build() {
            Preconditions.checkNotNull((Object)((Object)this.actionId));
            return new PiAction(this.actionId, this.runtimeParams);
        }
    }
}

