/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;

public final class PiHeaderFieldId
extends Identifier<String> {
    private final String headerName;
    private final String fieldName;
    private final int index;

    private PiHeaderFieldId(String headerName, String fieldName, int index) {
        super((Object)(headerName + (index > 0 ? "[" + String.valueOf(index) + "]" : "") + "." + fieldName));
        this.headerName = headerName;
        this.fieldName = fieldName;
        this.index = index;
    }

    public static PiHeaderFieldId of(String headerName, String fieldName, int index) {
        Preconditions.checkNotNull((Object)headerName);
        Preconditions.checkNotNull((Object)fieldName);
        Preconditions.checkArgument((!headerName.isEmpty() ? 1 : 0) != 0, (Object)"Header name can't be empty");
        Preconditions.checkArgument((!fieldName.isEmpty() ? 1 : 0) != 0, (Object)"Field name can't be empty");
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Index must be a positive integer");
        return new PiHeaderFieldId(headerName, fieldName, index);
    }

    public static PiHeaderFieldId of(String headerName, String fieldName) {
        return PiHeaderFieldId.of(headerName, fieldName, 0);
    }

    public String headerName() {
        return this.headerName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public int index() {
        return this.index;
    }
}

