/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiPacketMetadataId;

@Beta
public final class PiPacketMetadata {
    private final PiPacketMetadataId id;
    private final ImmutableByteSequence value;

    private PiPacketMetadata(PiPacketMetadataId id, ImmutableByteSequence value) {
        this.id = id;
        this.value = value;
    }

    public PiPacketMetadataId id() {
        return this.id;
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiPacketMetadata piPacket = (PiPacketMetadata)o;
        return Objects.equal((Object)((Object)this.id), (Object)((Object)piPacket.id())) && Objects.equal((Object)this.value, (Object)piPacket.value());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.value});
    }

    public String toString() {
        return this.id().toString() + " = " + this.value.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiPacketMetadataId id;
        private ImmutableByteSequence value;

        private Builder() {
        }

        public Builder withId(PiPacketMetadataId id) {
            this.id = id;
            return this;
        }

        public Builder withValue(ImmutableByteSequence value) {
            this.value = value;
            return this;
        }

        public PiPacketMetadata build() {
            Preconditions.checkNotNull((Object)((Object)this.id));
            Preconditions.checkNotNull((Object)this.value);
            return new PiPacketMetadata(this.id, this.value);
        }
    }
}

