/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.primitives.DefaultConsistentTreeMap;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentTreeMap;
import org.onosproject.store.service.Versioned;

public interface AsyncConsistentTreeMap<V>
extends AsyncConsistentMap<String, V> {
    public CompletableFuture<String> firstKey();

    public CompletableFuture<String> lastKey();

    public CompletableFuture<Map.Entry<String, Versioned<V>>> ceilingEntry(String var1);

    public CompletableFuture<Map.Entry<String, Versioned<V>>> floorEntry(String var1);

    public CompletableFuture<Map.Entry<String, Versioned<V>>> higherEntry(String var1);

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lowerEntry(String var1);

    public CompletableFuture<Map.Entry<String, Versioned<V>>> firstEntry();

    public CompletableFuture<Map.Entry<String, Versioned<V>>> lastEntry();

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollFirstEntry();

    public CompletableFuture<Map.Entry<String, Versioned<V>>> pollLastEntry();

    public CompletableFuture<String> lowerKey(String var1);

    public CompletableFuture<String> floorKey(String var1);

    public CompletableFuture<String> ceilingKey(String var1);

    public CompletableFuture<String> higherKey(String var1);

    public CompletableFuture<NavigableSet<String>> navigableKeySet();

    public CompletableFuture<NavigableMap<String, V>> subMap(String var1, String var2, boolean var3, boolean var4);

    default public ConsistentTreeMap<V> asTreeMap() {
        return this.asTreeMap(5000L);
    }

    default public ConsistentTreeMap<V> asTreeMap(long timeoutMillis) {
        return new DefaultConsistentTreeMap(this, timeoutMillis);
    }
}

