/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;

public class ObjectiveTest {
    private final TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    private final TrafficSelector selector = DefaultTrafficSelector.emptySelector();
    private final Criterion criterion = Criteria.dummy();
    private final Criterion key = Criteria.dummy();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultFilteringObjective.class);
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultForwardingObjective.class);
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultNextObjective.class);
    }

    private ForwardingObjective.Builder baseForwardingBuilder() {
        return DefaultForwardingObjective.builder().withSelector(this.selector).withTreatment(this.treatment).withFlag(ForwardingObjective.Flag.SPECIFIC).fromApp(NetTestTools.APP_ID).withPriority(22).makeTemporary(5).nextStep(33);
    }

    private void checkForwardingBase(ForwardingObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)objective.selector(), (Matcher)CoreMatchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)objective.treatment(), (Matcher)CoreMatchers.is((Object)this.treatment));
        MatcherAssert.assertThat((Object)objective.flag(), (Matcher)CoreMatchers.is((Object)ForwardingObjective.Flag.SPECIFIC));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.nextId(), (Matcher)CoreMatchers.is((Object)33));
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Object)0)));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)22));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testForwardingAdd() {
        this.checkForwardingBase(this.baseForwardingBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testForwardingAddWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkForwardingBase(this.baseForwardingBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, context);
    }

    @Test
    public void testForwardingRemove() {
        this.checkForwardingBase(this.baseForwardingBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testForwardingRemoveWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkForwardingBase(this.baseForwardingBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, context);
    }

    private FilteringObjective.Builder baseFilteringBuilder() {
        return DefaultFilteringObjective.builder().withKey(this.key).withPriority(5).addCondition(this.criterion).fromApp(NetTestTools.APP_ID).makeTemporary(2).deny();
    }

    private void checkFilteringBase(FilteringObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.key(), (Matcher)CoreMatchers.is((Object)this.key));
        MatcherAssert.assertThat((Object)objective.conditions(), (Matcher)CoreMatchers.hasItem((Object)this.criterion));
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.type(), (Matcher)CoreMatchers.is((Object)FilteringObjective.Type.DENY));
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Object)0)));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testFilteringAdd() {
        this.checkFilteringBase(this.baseFilteringBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testFilteringAddWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkFilteringBase(this.baseFilteringBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, context);
    }

    @Test
    public void testFilteringRemove() {
        this.checkFilteringBase(this.baseFilteringBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testFilteringRemoveWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkFilteringBase(this.baseFilteringBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, context);
    }

    private NextObjective.Builder baseNextBuilder() {
        return DefaultNextObjective.builder().addTreatment(this.treatment).withId(12).withType(NextObjective.Type.HASHED).makeTemporary(777).withPriority(33).fromApp(NetTestTools.APP_ID);
    }

    private void checkNextBase(NextObjective objective, Objective.Operation op, ObjectiveContext expectedContext) {
        MatcherAssert.assertThat((Object)objective.id(), (Matcher)CoreMatchers.is((Object)12));
        MatcherAssert.assertThat((Object)objective.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)objective.type(), (Matcher)CoreMatchers.is((Object)NextObjective.Type.HASHED));
        MatcherAssert.assertThat((Object)objective.next(), (Matcher)CoreMatchers.hasItem((Object)this.treatment));
        MatcherAssert.assertThat((Object)objective.permanent(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)objective.timeout(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)objective.priority(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)objective.op(), (Matcher)CoreMatchers.is((Object)op));
        if (objective.context().isPresent()) {
            MatcherAssert.assertThat(objective.context().get(), (Matcher)CoreMatchers.is((Object)expectedContext));
        } else {
            MatcherAssert.assertThat((Object)expectedContext, (Matcher)CoreMatchers.nullValue());
        }
    }

    @Test
    public void testNextAdd() {
        this.checkNextBase(this.baseNextBuilder().add(), Objective.Operation.ADD, null);
    }

    @Test
    public void testNextAddWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkNextBase(this.baseNextBuilder().add((ObjectiveContext)context), Objective.Operation.ADD, context);
    }

    @Test
    public void testNextRemove() {
        this.checkNextBase(this.baseNextBuilder().remove(), Objective.Operation.REMOVE, null);
    }

    @Test
    public void testNextRemoveWithContext() {
        MockObjectiveContext context = new MockObjectiveContext();
        this.checkNextBase(this.baseNextBuilder().remove((ObjectiveContext)context), Objective.Operation.REMOVE, context);
    }

    private static class MockObjectiveContext
    implements ObjectiveContext {
        private MockObjectiveContext() {
        }

        public void onSuccess(Objective objective) {
        }

        public void onError(Objective objective, ObjectiveError error) {
        }
    }
}

