/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.LatencyConstraint;
import org.onosproject.net.provider.ProviderId;

public class LatencyConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private static final String LATENCY1 = "3.0";
    private static final String LATENCY2 = "4.0";
    private LatencyConstraint sut;
    private ResourceContext resourceContext;
    private Path path;
    private Link link1;
    private Link link2;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        DefaultAnnotations annotations1 = DefaultAnnotations.builder().set("latency", LATENCY1).build();
        DefaultAnnotations annotations2 = DefaultAnnotations.builder().set("latency", LATENCY2).build();
        this.link1 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN1)).dst(DefaultLinkTest.cp((ElementId)DID2, PN2)).type(Link.Type.DIRECT).annotations((Annotations)annotations1).build();
        this.link2 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN3)).dst(DefaultLinkTest.cp((ElementId)DID3, PN4)).type(Link.Type.DIRECT).annotations((Annotations)annotations2).build();
        this.path = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link2), 10.0, new Annotations[0]);
    }

    @Test
    public void testLessThanLatency() {
        this.sut = new LatencyConstraint(Duration.of(10L, ChronoUnit.NANOS));
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMoreThanLatency() {
        this.sut = new LatencyConstraint(Duration.of(3L, ChronoUnit.NANOS));
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCost() {
        this.sut = new LatencyConstraint(Duration.of(10L, ChronoUnit.NANOS));
        Assert.assertThat((Object)this.sut.cost(this.link1, this.resourceContext), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)Double.parseDouble(LATENCY1), (double)1.0E-6)));
        Assert.assertThat((Object)this.sut.cost(this.link2, this.resourceContext), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)Double.parseDouble(LATENCY2), (double)1.0E-6)));
    }

    @Test
    public void testEquality() {
        LatencyConstraint c1 = new LatencyConstraint(Duration.of(1L, ChronoUnit.SECONDS));
        LatencyConstraint c2 = new LatencyConstraint(Duration.of(1000L, ChronoUnit.MILLIS));
        LatencyConstraint c3 = new LatencyConstraint(Duration.of(2L, ChronoUnit.SECONDS));
        LatencyConstraint c4 = new LatencyConstraint(Duration.of(2000L, ChronoUnit.MILLIS));
        new EqualsTester().addEqualityGroup(new Object[]{c1, c2}).addEqualityGroup(new Object[]{c3, c4}).testEquals();
    }
}

