/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionId;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiActionParamId;
import org.onosproject.net.pi.runtime.PiTableAction;

public class PiActionTest {
    final PiAction piAction1 = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    final PiAction sameAsPiAction1 = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    final PiAction piAction2 = PiAction.builder().withId(PiActionId.of((String)"set_egress_port_0")).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiAction.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piAction1, this.sameAsPiAction1}).addEqualityGroup(new Object[]{this.piAction2}).testEquals();
    }

    @Test
    public void testMethodWithParameter() {
        PiActionId piActionId = PiActionId.of((String)"mod_nw_dst");
        PiActionParam piActionParam = new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101));
        PiAction piAction = PiAction.builder().withId(piActionId).withParameter(piActionParam).build();
        MatcherAssert.assertThat((Object)piAction, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piAction.id(), (Matcher)Matchers.is((Object)piActionId));
        MatcherAssert.assertThat((Object)piAction.type(), (Matcher)Matchers.is((Object)PiTableAction.Type.ACTION));
    }

    @Test
    public void testMethodWithParameters() {
        PiActionId piActionId = PiActionId.of((String)"mod_nw_dst");
        ArrayList runtimeParams = Lists.newArrayList();
        PiActionParam piActionParam = new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101));
        runtimeParams.add(piActionParam);
        PiAction piAction = PiAction.builder().withId(piActionId).withParameters((Collection)runtimeParams).build();
        MatcherAssert.assertThat((Object)piAction, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piAction.id(), (Matcher)Matchers.is((Object)piActionId));
        MatcherAssert.assertThat((Object)piAction.parameters(), (Matcher)Matchers.is((Object)runtimeParams));
        MatcherAssert.assertThat((Object)piAction.type(), (Matcher)Matchers.is((Object)PiTableAction.Type.ACTION));
    }
}

