/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Maps;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionId;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableAction;
import org.onosproject.net.pi.runtime.PiTableEntry;
import org.onosproject.net.pi.runtime.PiTableId;

public class PiTableEntryTest {
    final PiTableEntry piTableEntry1 = PiTableEntry.builder().forTable(PiTableId.of((String)"Table10")).withCookie(172L).withPriority(10).withAction((PiTableAction)PiAction.builder().withId(PiActionId.of((String)"drop")).build()).withTimeout(100.0).build();
    final PiTableEntry sameAsPiTableEntry1 = PiTableEntry.builder().forTable(PiTableId.of((String)"Table10")).withCookie(172L).withPriority(10).withAction((PiTableAction)PiAction.builder().withId(PiActionId.of((String)"drop")).build()).withTimeout(100.0).build();
    final PiTableEntry piTableEntry2 = PiTableEntry.builder().forTable(PiTableId.of((String)"Table20")).withCookie(172L).withPriority(10).withAction((PiTableAction)PiAction.builder().withId(PiActionId.of((String)"drop")).build()).withTimeout(1000.0).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiTableEntry.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piTableEntry1, this.sameAsPiTableEntry1}).addEqualityGroup(new Object[]{this.piTableEntry2}).testEquals();
    }

    @Test
    public void testBuilder() {
        PiTableId piTableId = PiTableId.of((String)"table10");
        long cookie = 268370723L;
        int priority = 100;
        double timeout = 1000.0;
        PiHeaderFieldId piHeaderFieldId = PiHeaderFieldId.of((String)"ipv4_t", (String)"dstAddr");
        PiExactFieldMatch piFieldMatch = new PiExactFieldMatch(piHeaderFieldId, ImmutableByteSequence.copyFrom((int)0xA010101));
        PiAction piAction = PiAction.builder().withId(PiActionId.of((String)"drop")).build();
        HashMap fieldMatches = Maps.newHashMap();
        fieldMatches.put(piHeaderFieldId, piFieldMatch);
        PiTableEntry piTableEntry = PiTableEntry.builder().forTable(piTableId).withMatchKey(PiMatchKey.builder().addFieldMatches(fieldMatches.values()).build()).withAction((PiTableAction)piAction).withCookie(cookie).withPriority(priority).withTimeout(timeout).build();
        MatcherAssert.assertThat((Object)piTableEntry.table(), (Matcher)Matchers.is((Object)piTableId));
        MatcherAssert.assertThat((Object)piTableEntry.cookie(), (Matcher)Matchers.is((Object)cookie));
        MatcherAssert.assertThat(piTableEntry.priority().get(), (Matcher)Matchers.is((Object)priority));
        MatcherAssert.assertThat(piTableEntry.timeout().get(), (Matcher)Matchers.is((Object)timeout));
        MatcherAssert.assertThat((String)"Incorrect match param value", (boolean)CollectionUtils.isEqualCollection((Collection)piTableEntry.matchKey().fieldMatches(), fieldMatches.values()));
        MatcherAssert.assertThat((Object)piTableEntry.action(), (Matcher)Matchers.is((Object)piAction));
    }
}

