/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiMatchKey;

public class PiMatchKeyTest {
    final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    int prefixLength = 24;
    final PiHeaderFieldId piHeaderField1 = PiHeaderFieldId.of((String)"ipv4_t", (String)"srcAddr");
    final PiHeaderFieldId piHeaderField2 = PiHeaderFieldId.of((String)"ipv4_t", (String)"dstAddr");
    PiLpmFieldMatch piLpmFieldMatch1 = new PiLpmFieldMatch(this.piHeaderField1, this.value1, this.prefixLength);
    PiLpmFieldMatch piLpmFieldMatch2 = new PiLpmFieldMatch(this.piHeaderField2, this.value2, this.prefixLength);
    final PiMatchKey piMatchKey1 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch1).build();
    final PiMatchKey sameAsPiMatchKey1 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch1).build();
    final PiMatchKey piMatchKey2 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch2).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiMatchKey.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piMatchKey1, this.sameAsPiMatchKey1}).addEqualityGroup(new Object[]{this.piMatchKey2}).testEquals();
    }

    @Test
    public void testMethods() {
        ArrayList piFieldMatches = Lists.newArrayList();
        piFieldMatches.add(this.piLpmFieldMatch1);
        piFieldMatches.add(this.piLpmFieldMatch2);
        PiMatchKey piMatchKey = PiMatchKey.builder().addFieldMatches((Collection)piFieldMatches).build();
        MatcherAssert.assertThat((Object)piMatchKey, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((String)"Incorrect members value", (boolean)CollectionUtils.isEqualCollection((Collection)piMatchKey.fieldMatches(), (Collection)piFieldMatches));
    }
}

