/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.runtime.PiPacketMetadata;
import org.onosproject.net.pi.runtime.PiPacketMetadataId;

public class PiPacketMetadataTest {
    final PiPacketMetadataId piPacketMetadataId = PiPacketMetadataId.of((String)"egress_port");
    final PiPacketMetadata piPacketMetadata1 = PiPacketMetadata.builder().withId(this.piPacketMetadataId).withValue(ImmutableByteSequence.copyFrom((int)16)).build();
    final PiPacketMetadata sameAsPiPacketMetadata1 = PiPacketMetadata.builder().withId(this.piPacketMetadataId).withValue(ImmutableByteSequence.copyFrom((int)16)).build();
    final PiPacketMetadata piPacketMetadata2 = PiPacketMetadata.builder().withId(this.piPacketMetadataId).withValue(ImmutableByteSequence.copyFrom((int)32)).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiPacketMetadata.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piPacketMetadata1, this.sameAsPiPacketMetadata1}).addEqualityGroup(new Object[]{this.piPacketMetadata2}).testEquals();
    }

    @Test
    public void testMethods() {
        MatcherAssert.assertThat((Object)this.piPacketMetadata1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.piPacketMetadata1.id(), (Matcher)Matchers.is((Object)PiPacketMetadataId.of((String)"egress_port")));
        MatcherAssert.assertThat((Object)this.piPacketMetadata1.value(), (Matcher)Matchers.is((Object)ImmutableByteSequence.copyFrom((int)16)));
    }
}

