/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.config.basics.BasicElementConfig;

public final class BasicHostConfig
extends BasicElementConfig<HostId> {
    private static final String IPS = "ips";
    private static final String LOCATIONS = "locations";
    private static final String DASH = "-";

    @Override
    public boolean isValid() {
        this.locations();
        this.ipAddresses();
        return this.hasOnlyFields("allowed", "name", "locType", "latitude", "longitude", "gridY", "gridY", "uiType", "rackAddress", "owner", IPS, LOCATIONS);
    }

    @Override
    public String name() {
        return this.get("name", DASH);
    }

    public Set<HostLocation> locations() {
        if (!this.object.has(LOCATIONS)) {
            return null;
        }
        ImmutableSet.Builder locationsSetBuilder = ImmutableSet.builder();
        ArrayNode locationNodes = (ArrayNode)this.object.path(LOCATIONS);
        locationNodes.forEach(n -> {
            ConnectPoint cp = ConnectPoint.deviceConnectPoint(n.asText());
            locationsSetBuilder.add((Object)new HostLocation(cp, 0L));
        });
        ImmutableSet locations = locationsSetBuilder.build();
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("Host should have at least one location");
        }
        return locations;
    }

    public BasicHostConfig setLocations(Set<HostLocation> locations) {
        return (BasicHostConfig)this.setOrClear(LOCATIONS, locations);
    }

    public Set<IpAddress> ipAddresses() {
        HashSet<IpAddress> ipAddresses = new HashSet<IpAddress>();
        if (this.object.has(IPS)) {
            ArrayNode ipNodes = (ArrayNode)this.object.path(IPS);
            ipNodes.forEach(n -> ipAddresses.add(IpAddress.valueOf((String)n.asText())));
            return ipAddresses;
        }
        return null;
    }

    public BasicHostConfig setIps(Set<IpAddress> ipAddresses) {
        return (BasicHostConfig)this.setOrClear(IPS, ipAddresses);
    }
}

