/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import java.util.Objects;
import org.onlab.packet.EthType;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L2ModificationInstruction
implements Instruction {
    private static final String SEPARATOR = ":";

    public abstract L2SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L2MODIFICATION;
    }

    public static final class ModTunnelIdInstruction
    extends L2ModificationInstruction {
        private final long tunnelId;

        ModTunnelIdInstruction(long tunnelId) {
            this.tunnelId = tunnelId;
        }

        public long tunnelId() {
            return this.tunnelId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.TUNNEL_ID;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + Long.toHexString(this.tunnelId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.tunnelId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModTunnelIdInstruction) {
                ModTunnelIdInstruction that = (ModTunnelIdInstruction)obj;
                return Objects.equals(this.tunnelId, that.tunnelId);
            }
            return false;
        }
    }

    public static final class ModMplsTtlInstruction
    extends L2ModificationInstruction {
        ModMplsTtlInstruction() {
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.DEC_MPLS_TTL;
        }

        public String toString() {
            return this.subtype().toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof ModMplsTtlInstruction;
        }
    }

    public static final class ModMplsBosInstruction
    extends L2ModificationInstruction {
        private final boolean mplsBos;

        ModMplsBosInstruction(boolean mplsBos) {
            this.mplsBos = mplsBos;
        }

        public boolean mplsBos() {
            return this.mplsBos;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_BOS;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.mplsBos;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mplsBos});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsBosInstruction) {
                ModMplsBosInstruction that = (ModMplsBosInstruction)obj;
                return Objects.equals(this.mplsBos, that.mplsBos());
            }
            return false;
        }
    }

    public static final class ModMplsLabelInstruction
    extends L2ModificationInstruction {
        private final MplsLabel mplsLabel;

        ModMplsLabelInstruction(MplsLabel mplsLabel) {
            this.mplsLabel = mplsLabel;
        }

        public MplsLabel label() {
            return this.mplsLabel;
        }

        @Deprecated
        public MplsLabel mplsLabel() {
            return this.label();
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.MPLS_LABEL;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.mplsLabel;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mplsLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsLabelInstruction) {
                ModMplsLabelInstruction that = (ModMplsLabelInstruction)obj;
                return Objects.equals(this.mplsLabel, that.mplsLabel);
            }
            return false;
        }
    }

    public static final class ModVlanHeaderInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private EthType ethernetType;

        ModVlanHeaderInstruction(L2SubType subType, EthType ethernetType) {
            this.subtype = subType;
            this.ethernetType = ethernetType;
        }

        ModVlanHeaderInstruction(L2SubType subType) {
            this(subType, EthType.EtherType.UNKNOWN.ethType());
        }

        public EthType ethernetType() {
            return this.ethernetType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return this.subtype().equals((Object)L2SubType.VLAN_POP) ? this.subtype().toString() : this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.ethernetType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.ethernetType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanHeaderInstruction) {
                ModVlanHeaderInstruction that = (ModVlanHeaderInstruction)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype) && Objects.equals(this.ethernetType, that.ethernetType);
            }
            return false;
        }
    }

    public static final class ModVlanPcpInstruction
    extends L2ModificationInstruction {
        private static final byte MASK = 7;
        private final byte vlanPcp;

        ModVlanPcpInstruction(byte vlanPcp) {
            this.vlanPcp = (byte)(vlanPcp & 7);
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_PCP;
        }

        public byte vlanPcp() {
            return this.vlanPcp;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + Long.toHexString(this.vlanPcp);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanPcp});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanPcpInstruction) {
                ModVlanPcpInstruction that = (ModVlanPcpInstruction)obj;
                return Objects.equals(this.vlanPcp, that.vlanPcp);
            }
            return false;
        }
    }

    public static final class ModVlanIdInstruction
    extends L2ModificationInstruction {
        private final VlanId vlanId;

        ModVlanIdInstruction(VlanId vlanId) {
            this.vlanId = vlanId;
        }

        @Override
        public L2SubType subtype() {
            return L2SubType.VLAN_ID;
        }

        public VlanId vlanId() {
            return this.vlanId;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.vlanId;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.vlanId});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModVlanIdInstruction) {
                ModVlanIdInstruction that = (ModVlanIdInstruction)obj;
                return Objects.equals(this.vlanId, that.vlanId);
            }
            return false;
        }
    }

    public static final class ModMplsHeaderInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final EthType ethernetType;

        ModMplsHeaderInstruction(L2SubType subType, EthType ethernetType) {
            this.subtype = subType;
            this.ethernetType = ethernetType;
        }

        public EthType ethernetType() {
            return this.ethernetType;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.ethernetType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.ethernetType});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModMplsHeaderInstruction) {
                ModMplsHeaderInstruction that = (ModMplsHeaderInstruction)obj;
                return Objects.equals((Object)this.subtype, (Object)that.subtype) && Objects.equals(this.ethernetType, that.ethernetType);
            }
            return false;
        }
    }

    public static final class ModEtherInstruction
    extends L2ModificationInstruction {
        private final L2SubType subtype;
        private final MacAddress mac;

        ModEtherInstruction(L2SubType subType, MacAddress addr) {
            this.subtype = subType;
            this.mac = addr;
        }

        @Override
        public L2SubType subtype() {
            return this.subtype;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return this.subtype().toString() + L2ModificationInstruction.SEPARATOR + this.mac;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype, this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModEtherInstruction) {
                ModEtherInstruction that = (ModEtherInstruction)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.subtype, (Object)that.subtype);
            }
            return false;
        }
    }

    public static enum L2SubType {
        ETH_SRC,
        ETH_DST,
        VLAN_ID,
        VLAN_PCP,
        MPLS_LABEL,
        MPLS_PUSH,
        MPLS_POP,
        DEC_MPLS_TTL,
        VLAN_POP,
        VLAN_PUSH,
        TUNNEL_ID,
        MPLS_BOS;

    }
}

