/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.onlab.util.Identifier;
import org.onosproject.net.flow.TableId;

@Beta
public final class PiTableId
extends Identifier<String>
implements TableId {
    private final String scope;
    private final String name;

    private PiTableId(String scope, String name) {
        super((Object)((scope != null ? scope + "." : "") + name));
        this.scope = scope;
        this.name = name;
    }

    public static PiTableId of(String scope, String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name can't be empty");
        Preconditions.checkArgument((!scope.isEmpty() ? 1 : 0) != 0, (Object)"Scope can't be empty");
        return new PiTableId(scope, name);
    }

    public static PiTableId of(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name can't be empty");
        return new PiTableId(null, name);
    }

    public String name() {
        return this.name;
    }

    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public TableId.Type type() {
        return TableId.Type.PIPELINE_INDEPENDENT;
    }
}

