/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;

public class PiExactFieldMatchTest {
    final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)2048);
    final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)2054);
    final PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"ethernet_t", (String)"etherType");
    PiExactFieldMatch piExactFieldMatch1 = new PiExactFieldMatch(this.piHeaderField, this.value1);
    PiExactFieldMatch sameAsPiExactFieldMatch1 = new PiExactFieldMatch(this.piHeaderField, this.value1);
    PiExactFieldMatch piExactFieldMatch2 = new PiExactFieldMatch(this.piHeaderField, this.value2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiExactFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piExactFieldMatch1, this.sameAsPiExactFieldMatch1}).addEqualityGroup(new Object[]{this.piExactFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)2054);
        PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"ethernet_t", (String)"etherType");
        PiExactFieldMatch piExactFieldMatch = new PiExactFieldMatch(piHeaderField, value);
        MatcherAssert.assertThat((Object)piExactFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piExactFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piExactFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.EXACT));
    }
}

