/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cfg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ConfigProperty {
    private final String name;
    private final Type type;
    private final String value;
    private final String defaultValue;
    private final String description;
    private final boolean isSet;

    public static ConfigProperty defineProperty(String name, Type type, String defaultValue, String description) {
        return new ConfigProperty(name, type, description, defaultValue, defaultValue, false);
    }

    public static ConfigProperty setProperty(ConfigProperty property, String newValue) {
        return new ConfigProperty(property.name, property.type, property.description, property.defaultValue, newValue, true);
    }

    public static ConfigProperty resetProperty(ConfigProperty property) {
        return new ConfigProperty(property.name, property.type, property.description, property.defaultValue, property.defaultValue, false);
    }

    private ConfigProperty(String name, Type type, String description, String defaultValue, String value, boolean isSet) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Property name cannot be null");
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Property type cannot be null"));
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"Property description cannot be null");
        this.defaultValue = defaultValue;
        this.value = value;
        this.isSet = isSet;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String value() {
        return this.value;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public String asString() {
        return this.value;
    }

    public byte asByte() {
        Preconditions.checkState((this.type == Type.BYTE ? 1 : 0) != 0, (Object)"Value is not a byte");
        return Byte.parseByte(this.value);
    }

    public int asInteger() {
        Preconditions.checkState((this.type == Type.INTEGER ? 1 : 0) != 0, (Object)"Value is not an integer");
        return Integer.parseInt(this.value);
    }

    public long asLong() {
        Preconditions.checkState((this.type == Type.INTEGER || this.type == Type.LONG ? 1 : 0) != 0, (Object)"Value is not a long or integer");
        return Long.parseLong(this.value);
    }

    public float asFloat() {
        Preconditions.checkState((this.type == Type.FLOAT ? 1 : 0) != 0, (Object)"Value is not a float");
        return Float.parseFloat(this.value);
    }

    public double asDouble() {
        Preconditions.checkState((this.type == Type.FLOAT || this.type == Type.DOUBLE ? 1 : 0) != 0, (Object)"Value is not a float or double");
        return Double.parseDouble(this.value);
    }

    public boolean asBoolean() {
        Preconditions.checkState((this.type == Type.BOOLEAN ? 1 : 0) != 0, (Object)"Value is not a boolean");
        return Boolean.parseBoolean(this.value);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConfigProperty) {
            ConfigProperty other = (ConfigProperty)obj;
            return Objects.equals(this.name, other.name);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("value", (Object)this.value).add("defaultValue", (Object)this.defaultValue).add("description", (Object)this.description).add("isSet", this.isSet).toString();
    }

    public static enum Type {
        STRING,
        BYTE,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN;

    }
}

