/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.PortDescription;

public class DefaultPortDescription
extends AbstractDescription
implements PortDescription {
    private static final long DEFAULT_SPEED = 1000L;
    private final PortNumber number;
    private final boolean isEnabled;
    private final boolean isRemoved;
    private final Port.Type type;
    private final long portSpeed;

    public DefaultPortDescription(PortNumber number, boolean isEnabled, SparseAnnotations ... annotations) {
        this(number, isEnabled, Port.Type.COPPER, 1000L, annotations);
    }

    public DefaultPortDescription(PortNumber number, boolean isEnabled, Port.Type type, long portSpeed, SparseAnnotations ... annotations) {
        this(number, isEnabled, false, type, portSpeed, annotations);
    }

    public DefaultPortDescription(PortNumber number, boolean isEnabled, boolean isRemoved, Port.Type type, long portSpeed, SparseAnnotations ... annotations) {
        super(annotations);
        this.number = (PortNumber)Preconditions.checkNotNull((Object)number);
        this.isEnabled = isEnabled;
        this.isRemoved = isRemoved;
        this.type = type;
        this.portSpeed = portSpeed;
    }

    protected DefaultPortDescription() {
        this.number = null;
        this.isEnabled = false;
        this.isRemoved = false;
        this.portSpeed = 1000L;
        this.type = Port.Type.COPPER;
    }

    public DefaultPortDescription(PortDescription base, SparseAnnotations annotations) {
        this(base.portNumber(), base.isEnabled(), base.type(), base.portSpeed(), annotations);
    }

    public static DefaultPortDescription copyReplacingAnnotation(PortDescription base, SparseAnnotations annotations) {
        return new DefaultPortDescription(base, annotations);
    }

    @Override
    public PortNumber portNumber() {
        return this.number;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public Port.Type type() {
        return this.type;
    }

    @Override
    public long portSpeed() {
        return this.portSpeed;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("number", (Object)this.number).add("isEnabled", this.isEnabled).add("type", (Object)this.type).add("portSpeed", this.portSpeed).add("annotations", (Object)this.annotations()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.number, this.isEnabled, this.type, this.portSpeed});
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            if (!super.equals(object)) {
                return false;
            }
            DefaultPortDescription that = (DefaultPortDescription)object;
            return Objects.equal((Object)this.number, (Object)that.number) && Objects.equal((Object)this.isEnabled, (Object)that.isEnabled) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.portSpeed, (Object)that.portSpeed);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PortDescription desc) {
        return new Builder(desc);
    }

    public static class Builder {
        private PortNumber number;
        private boolean isEnabled = true;
        private boolean isRemoved = false;
        private Port.Type type = Port.Type.COPPER;
        private long portSpeed = 1000L;
        private SparseAnnotations annotations = DefaultAnnotations.EMPTY;

        Builder() {
        }

        Builder(PortDescription desc) {
            this.number = desc.portNumber();
            this.isEnabled = desc.isEnabled();
            this.isRemoved = desc.isRemoved();
            this.type = desc.type();
            this.portSpeed = desc.portSpeed();
            this.annotations = desc.annotations();
        }

        public Builder withPortNumer(PortNumber number) {
            this.number = (PortNumber)Preconditions.checkNotNull((Object)number);
            return this;
        }

        public Builder isEnabled(boolean enabled) {
            this.isEnabled = enabled;
            return this;
        }

        public Builder isRemoved(boolean removed) {
            this.isRemoved = removed;
            return this;
        }

        public Builder type(Port.Type type) {
            this.type = type;
            return this;
        }

        public Builder portSpeed(long mbps) {
            this.portSpeed = mbps;
            return this;
        }

        public Builder annotations(SparseAnnotations annotations) {
            this.annotations = (SparseAnnotations)Preconditions.checkNotNull((Object)annotations);
            return this;
        }

        public DefaultPortDescription build() {
            return new DefaultPortDescription(this.number, this.isEnabled, this.isRemoved, this.type, this.portSpeed, this.annotations);
        }
    }
}

