/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.onosproject.net.pi.runtime.PiActionGroupId;
import org.onosproject.net.pi.runtime.PiActionGroupMember;
import org.onosproject.net.pi.runtime.PiActionGroupMemberId;

@Beta
public final class PiActionGroup {
    private final PiActionGroupId id;
    private final Type type;
    private final ImmutableSet<PiActionGroupMember> members;

    private PiActionGroup(PiActionGroupId id, Type type, ImmutableSet<PiActionGroupMember> members) {
        this.id = id;
        this.type = type;
        this.members = members;
    }

    public PiActionGroupId id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public Collection<PiActionGroupMember> members() {
        return this.members;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiActionGroup that = (PiActionGroup)o;
        return this.id == that.id && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal(this.members, that.members);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.type, this.members});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", (Object)this.id).add("type", (Object)this.type).add("members", this.members).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private PiActionGroupId id;
        private Type type;
        private Map<PiActionGroupMemberId, PiActionGroupMember> members = Maps.newHashMap();

        private Builder() {
        }

        public Builder withId(PiActionGroupId id) {
            this.id = id;
            return this;
        }

        public Builder withType(Type type) {
            this.type = type;
            return this;
        }

        public Builder addMember(PiActionGroupMember member) {
            this.members.put(member.id(), member);
            return this;
        }

        public Builder addMembers(Collection<PiActionGroupMember> members) {
            members.forEach(this::addMember);
            return this;
        }

        public PiActionGroup build() {
            Preconditions.checkNotNull((Object)this.id);
            Preconditions.checkNotNull((Object)((Object)this.type));
            Preconditions.checkArgument((this.members.size() > 0 ? 1 : 0) != 0, (Object)"Members cannot be empty");
            return new PiActionGroup(this.id, this.type, ImmutableSet.copyOf(this.members.values()));
        }
    }

    public static enum Type {
        SELECT;

    }
}

