/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.provider.ProviderId;

public class PathIntentTest
extends ConnectivityIntentTest {
    private static final Path PATH1 = NetTestTools.createPath("111", "222");
    private static final Path PATH2 = NetTestTools.createPath("222", "333");
    private final ProviderId provider1 = new ProviderId("of", "1");
    private final DeviceId device1 = DeviceId.deviceId((String)"1");
    private final DeviceId device2 = DeviceId.deviceId((String)"2");
    private final PortNumber port1 = PortNumber.portNumber((long)1L);
    private final PortNumber port2 = PortNumber.portNumber((long)2L);
    private final PortNumber port3 = PortNumber.portNumber((long)3L);
    private final PortNumber port4 = PortNumber.portNumber((long)4L);
    private final ConnectPoint cp1 = new ConnectPoint((ElementId)this.device1, this.port1);
    private final ConnectPoint cp2 = new ConnectPoint((ElementId)this.device1, this.port2);
    private final ConnectPoint cp3 = new ConnectPoint((ElementId)this.device2, this.port3);
    private final ConnectPoint cp4 = new ConnectPoint((ElementId)this.device2, this.port4);
    private final DefaultLink link1 = DefaultLink.builder().providerId(this.provider1).src(this.cp1).dst(this.cp2).type(Link.Type.DIRECT).build();
    private final DefaultLink link2 = DefaultLink.builder().providerId(this.provider1).src(this.cp1).dst(this.cp2).type(Link.Type.DIRECT).build();
    private final double cost = 1.0;

    @Test
    public void basics() {
        PathIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect action", (Object)NOP, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect path", (Object)PATH1, (Object)intent.path());
        Assert.assertEquals((String)"incorrect key", (Object)KEY, (Object)intent.key());
        intent = this.createAnother();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect action", (Object)NOP, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect path", (Object)PATH2, (Object)intent.path());
        Assert.assertEquals((String)"incorrect key", (Object)KEY, (Object)intent.key());
        intent = this.createWithResourceGroup();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect action", (Object)NOP, (Object)intent.treatment());
        Assert.assertEquals((String)"incorrect path", (Object)PATH2, (Object)intent.path());
        Assert.assertEquals((String)"incorrect key", (Object)KEY, (Object)intent.key());
        Assert.assertEquals((String)"incorrect resource group", (Object)RESOURCE_GROUP, (Object)intent.resourceGroup());
    }

    protected PathIntent createOne() {
        return PathIntent.builder().appId(APPID).key(KEY).selector(MATCH).treatment(NOP).path(PATH1).build();
    }

    protected PathIntent createAnother() {
        return PathIntent.builder().appId(APPID).key(KEY).selector(MATCH).treatment(NOP).path(PATH2).build();
    }

    protected PathIntent createWithResourceGroup() {
        return PathIntent.builder().appId(APPID).key(KEY).selector(MATCH).treatment(NOP).path(PATH2).resourceGroup(RESOURCE_GROUP).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRaiseExceptionWhenSameDevices() {
        PathIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).path((Path)new DefaultPath(this.provider1, Collections.singletonList(this.link1), 1.0, new Annotations[0])).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRaiseExceptionWhenDifferentDevice() {
        PathIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).path((Path)new DefaultPath(this.provider1, Arrays.asList(this.link1, this.link2), 1.0, new Annotations[0])).build();
    }
}

