/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;
import org.onosproject.net.pi.runtime.PiRangeFieldMatch;

public class PiRangeFieldMatchTest {
    final ImmutableByteSequence high1 = ImmutableByteSequence.copyFrom((int)16);
    final ImmutableByteSequence low1 = ImmutableByteSequence.copyFrom((int)0);
    final ImmutableByteSequence high2 = ImmutableByteSequence.copyFrom((int)48);
    final ImmutableByteSequence low2 = ImmutableByteSequence.copyFrom((int)64);
    final PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"vlan_tag_t", (String)"vid");
    PiRangeFieldMatch piRangeFieldMatch1 = new PiRangeFieldMatch(this.piHeaderField, this.low1, this.high1);
    PiRangeFieldMatch sameAsPiRangeFieldMatch1 = new PiRangeFieldMatch(this.piHeaderField, this.low1, this.high1);
    PiRangeFieldMatch piRangeFieldMatch2 = new PiRangeFieldMatch(this.piHeaderField, this.low2, this.high2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiRangeFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piRangeFieldMatch1, this.sameAsPiRangeFieldMatch1}).addEqualityGroup(new Object[]{this.piRangeFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence high = ImmutableByteSequence.copyFrom((int)80);
        ImmutableByteSequence low = ImmutableByteSequence.copyFrom((int)0);
        PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"vlan_tag_t", (String)"vid");
        PiRangeFieldMatch piRangeFieldMatch = new PiRangeFieldMatch(piHeaderField, low, high);
        MatcherAssert.assertThat((Object)piRangeFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piRangeFieldMatch.lowValue(), (Matcher)Matchers.is((Object)low));
        MatcherAssert.assertThat((Object)piRangeFieldMatch.highValue(), (Matcher)Matchers.is((Object)high));
        MatcherAssert.assertThat((Object)piRangeFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.RANGE));
    }
}

