/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiHeaderFieldId;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;

public class PiTernaryFieldMatchTest {
    final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    final ImmutableByteSequence mask1 = ImmutableByteSequence.copyFrom((int)0xFFFFFF);
    final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    final ImmutableByteSequence mask2 = ImmutableByteSequence.copyFrom((int)65535);
    final PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"ipv4_t", (String)"dstAddr");
    PiTernaryFieldMatch piTernaryFieldMatch1 = new PiTernaryFieldMatch(this.piHeaderField, this.value1, this.mask1);
    PiTernaryFieldMatch sameAsPiTernaryFieldMatch1 = new PiTernaryFieldMatch(this.piHeaderField, this.value1, this.mask1);
    PiTernaryFieldMatch piTernaryFieldMatch2 = new PiTernaryFieldMatch(this.piHeaderField, this.value2, this.mask2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiTernaryFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piTernaryFieldMatch1, this.sameAsPiTernaryFieldMatch1}).addEqualityGroup(new Object[]{this.piTernaryFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)0xA01010A);
        ImmutableByteSequence mask = ImmutableByteSequence.copyFrom((int)0xFFFFFF);
        PiHeaderFieldId piHeaderField = PiHeaderFieldId.of((String)"ipv4_t", (String)"dstAddr");
        PiTernaryFieldMatch piTernaryFieldMatch = new PiTernaryFieldMatch(piHeaderField, value, mask);
        MatcherAssert.assertThat((Object)piTernaryFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.mask(), (Matcher)Matchers.is((Object)mask));
        MatcherAssert.assertThat((Object)piTernaryFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.TERNARY));
    }
}

