/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.runtime.PiCounterType;

@Beta
public final class PiCounterId {
    private final String name;
    private final PiCounterType type;

    private PiCounterId(String name, PiCounterType type) {
        this.name = name;
        this.type = type;
    }

    public static PiCounterId of(String name, PiCounterType type) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name can't be empty");
        return new PiCounterId(name, type);
    }

    public String name() {
        return this.name;
    }

    public PiCounterType type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiCounterId)) {
            return false;
        }
        PiCounterId that = (PiCounterId)o;
        return Objects.equal((Object)this.name, (Object)that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public String toString() {
        return this.type.name().toLowerCase() + ":" + this.name;
    }
}

