/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.runtime.PiCounterCellId;
import org.onosproject.net.pi.runtime.PiCounterId;
import org.onosproject.net.pi.runtime.PiCounterType;
import org.onosproject.net.pi.runtime.PiTableEntry;

@Beta
public final class PiDirectCounterCellId
implements PiCounterCellId {
    private final PiCounterId counterId;
    private final PiTableEntry tableEntry;

    private PiDirectCounterCellId(PiCounterId counterId, PiTableEntry tableEntry) {
        this.counterId = counterId;
        this.tableEntry = tableEntry;
    }

    public static PiDirectCounterCellId of(PiCounterId counterId, PiTableEntry tableEntry) {
        Preconditions.checkNotNull((Object)counterId);
        Preconditions.checkNotNull((Object)tableEntry);
        Preconditions.checkArgument((counterId.type() == PiCounterType.DIRECT ? 1 : 0) != 0, (Object)"Counter ID must be of type DIRECT");
        return new PiDirectCounterCellId(counterId, tableEntry);
    }

    public PiTableEntry tableEntry() {
        return this.tableEntry;
    }

    @Override
    public PiCounterId counterId() {
        return this.counterId;
    }

    @Override
    public PiCounterType type() {
        return PiCounterType.DIRECT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PiDirectCounterCellId)) {
            return false;
        }
        PiDirectCounterCellId that = (PiDirectCounterCellId)o;
        return Objects.equal((Object)this.counterId, (Object)that.counterId) && Objects.equal((Object)this.tableEntry, (Object)that.tableEntry);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.counterId, this.tableEntry});
    }

    public String toString() {
        return String.format("%s[{%s}]", this.counterId, this.tableEntry);
    }
}

