/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.net.pi.runtime.PiCounterCellId;
import org.onosproject.net.pi.runtime.PiCounterId;
import org.onosproject.net.pi.runtime.PiCounterType;

@Beta
public final class PiIndirectCounterCellId
extends Identifier<String>
implements PiCounterCellId {
    private final PiCounterId counterId;
    private final long index;

    private PiIndirectCounterCellId(PiCounterId counterId, long index) {
        super((Object)(counterId.toString() + "[" + index + "]"));
        this.counterId = counterId;
        this.index = index;
    }

    public static PiIndirectCounterCellId of(PiCounterId counterId, long index) {
        Preconditions.checkNotNull((Object)counterId);
        Preconditions.checkArgument((counterId.type() == PiCounterType.INDIRECT ? 1 : 0) != 0, (Object)"Counter ID must be of type INDIRECT");
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"Index must be a positive integer");
        return new PiIndirectCounterCellId(counterId, index);
    }

    public long index() {
        return this.index;
    }

    @Override
    public PiCounterId counterId() {
        return this.counterId;
    }

    @Override
    public PiCounterType type() {
        return PiCounterType.INDIRECT;
    }
}

