/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentTest;
import org.onosproject.net.intent.Key;

public class FlowObjectiveIntentTest
extends IntentTest {
    private static final ApplicationId APP_ID = new DefaultApplicationId(1, "foo");
    private static final Key KEY = Key.of((String)"bar", (ApplicationId)APP_ID);
    private static final Objective FO1 = DefaultFilteringObjective.builder().fromApp(APP_ID).addCondition(Criteria.matchEthType((int)123)).permit().add();
    private static final Objective FO2 = DefaultForwardingObjective.builder().fromApp(APP_ID).withSelector(DefaultTrafficSelector.builder().matchEthType((short)123).build()).withTreatment(DefaultTrafficTreatment.emptyTreatment()).withFlag(ForwardingObjective.Flag.VERSATILE).add();
    private static final List<Objective> OBJECTIVES = ImmutableList.of((Object)FO1, (Object)FO2);
    private static final Collection<NetworkResource> RESOURCES = ImmutableSet.of();
    private static final List<DeviceId> DEVICE = ImmutableList.of((Object)DeviceId.NONE, (Object)DeviceId.NONE);
    private static final ResourceGroup RESOURCE_GROUP = ResourceGroup.of((long)0L);

    @Test
    public void basics() {
        FlowObjectiveIntent intent = new FlowObjectiveIntent(APP_ID, KEY, DEVICE, OBJECTIVES, RESOURCES, RESOURCE_GROUP);
        Assert.assertEquals((String)"incorrect app id", (Object)APP_ID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect key", (Object)KEY, (Object)intent.key());
        Assert.assertEquals((String)"incorrect objectives", OBJECTIVES, (Object)intent.objectives());
        Assert.assertEquals((String)"incorrect resources", RESOURCES, (Object)intent.resources());
        Assert.assertEquals((String)"incorrect resource group", (Object)RESOURCE_GROUP, (Object)intent.resourceGroup());
        Assert.assertTrue((String)"should be installable", (boolean)intent.isInstallable());
    }

    @Test
    public void equality() {
        Intent a = this.createOne();
        Intent b = this.createAnother();
        new EqualsTester().addEqualityGroup(new Object[]{a}).addEqualityGroup(new Object[]{b}).testEquals();
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(HostToHostIntent.class);
    }

    @Override
    protected Intent createOne() {
        return new FlowObjectiveIntent(APP_ID, DEVICE, OBJECTIVES, RESOURCES);
    }

    @Override
    protected Intent createAnother() {
        return new FlowObjectiveIntent(APP_ID, DEVICE, OBJECTIVES, RESOURCES);
    }
}

