/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;

public class LinkKeyTest {
    static final DeviceId D1 = DeviceId.deviceId((String)"1");
    static final DeviceId D2 = DeviceId.deviceId((String)"2");
    static final PortNumber P1 = PortNumber.portNumber((long)1L);
    static final PortNumber P2 = PortNumber.portNumber((long)2L);
    static final ConnectPoint SRC1 = new ConnectPoint((ElementId)D1, P1);
    static final ConnectPoint DST1 = new ConnectPoint((ElementId)D2, P1);
    static final ConnectPoint DST2 = new ConnectPoint((ElementId)D2, P2);

    @Test
    public void testLinkKeyImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(LinkKey.class);
    }

    @Test(expected=NullPointerException.class)
    public void testNullSrc() {
        LinkKey key = LinkKey.linkKey(null, (ConnectPoint)DST1);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDst() {
        LinkKey key = LinkKey.linkKey((ConnectPoint)SRC1, null);
    }

    @Test
    public void testCompareEquals() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        LinkKey k2 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        MatcherAssert.assertThat((Object)k1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)k2)));
    }

    @Test
    public void testCompareNotEquals() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST1);
        LinkKey k2 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        MatcherAssert.assertThat((Object)k1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)k2))));
        MatcherAssert.assertThat((Object)k1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)new Object()))));
    }

    @Test
    public void testHashCodeEquals() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        LinkKey k2 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        MatcherAssert.assertThat((Object)k1.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)k2.hashCode())));
    }

    @Test
    public void testHashCodeNotEquals() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST1);
        LinkKey k2 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        MatcherAssert.assertThat((Object)k1.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)k2.hashCode()))));
    }

    @Test
    public void testToString() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST1);
        String k1String = k1.toString();
        MatcherAssert.assertThat((Object)k1String, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"LinkKey{"), (Matcher)CoreMatchers.containsString((String)"src=1/1"), (Matcher)CoreMatchers.containsString((String)"dst=2/1}")));
    }

    @Test
    public void asId() {
        LinkKey k1 = LinkKey.linkKey((ConnectPoint)SRC1, (ConnectPoint)DST2);
        MatcherAssert.assertThat((Object)k1.asId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"1/1-2/2")));
    }
}

