/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onosproject.net.behaviour.trafficcontrol.DefaultTokenBucket;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;

public class TokenBucketTest {
    private static final long RATE = 1L;
    private static final short DSCP_PREC = 2;
    private static final short DSCP_CL = 250;
    private static final short WRONG_DSCP = -1;
    @Rule
    public ExpectedException exceptionNullAction = ExpectedException.none();
    @Rule
    public ExpectedException exceptionWrongDscp = ExpectedException.none();

    @Test
    public void testDropCreation() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).build();
        Assert.assertThat((Object)drop, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)drop.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)drop.burstSize(), (Matcher)Matchers.is((Object)3000L));
        Assert.assertThat((Object)drop.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DROP));
    }

    @Test
    public void testDscpPrecCreation() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withBurstSize(9000L).withDscp((short)2).build();
        Assert.assertThat((Object)drop, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)drop.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)drop.burstSize(), (Matcher)Matchers.is((Object)9000L));
        Assert.assertThat((Object)drop.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DSCP_PRECEDENCE));
        Assert.assertThat((Object)drop.dscp(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testDscpClassCreation() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_CLASS).withDscp((short)250).build();
        Assert.assertThat((Object)drop, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)drop.rate(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)drop.burstSize(), (Matcher)Matchers.is((Object)3000L));
        Assert.assertThat((Object)drop.action(), (Matcher)Matchers.is((Object)TokenBucket.Action.DSCP_CLASS));
        Assert.assertThat((Object)drop.dscp(), (Matcher)Matchers.is((Object)250));
    }

    @Test
    public void testNullActionCreation() {
        this.exceptionNullAction.expect(NullPointerException.class);
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).build();
    }

    @Test
    public void testWrongDscpCreation() {
        this.exceptionWrongDscp.expect(IllegalArgumentException.class);
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)-1).build();
    }

    @Test
    public void testEqualilty() {
        TokenBucket drop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).build();
        TokenBucket mark = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DSCP_PRECEDENCE).withDscp((short)2).build();
        TokenBucket copyDrop = DefaultTokenBucket.builder().withRate(1L).withAction(TokenBucket.Action.DROP).build();
        Assert.assertEquals((Object)drop, (Object)copyDrop);
        Assert.assertNotEquals((Object)mark, (Object)drop);
        Assert.assertNotEquals((Object)mark, (Object)copyDrop);
    }
}

