/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Set;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.ObstacleConstraint;
import org.onosproject.net.provider.ProviderId;

public class ObstacleConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final DeviceId DID4 = DeviceId.deviceId((String)"of:4");
    private static final DeviceId DID5 = DeviceId.deviceId((String)"of:5");
    private static final DeviceId DID6 = DeviceId.deviceId((String)"of:6");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private ResourceContext resourceContext;
    private Path path;
    private Path pathWithEdgeLink;
    private DefaultLink link1;
    private DefaultLink link2;
    private DefaultLink edgelink1;
    private DefaultLink edgelink2;
    private DefaultHost host1;
    private DefaultHost host2;
    private ObstacleConstraint sut;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        this.link1 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN1)).dst(DefaultLinkTest.cp((ElementId)DID2, PN2)).type(Link.Type.DIRECT).build();
        this.link2 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN3)).dst(DefaultLinkTest.cp((ElementId)DID3, PN4)).type(Link.Type.DIRECT).build();
        this.host1 = new DefaultHost(PROVIDER_ID, HostId.hostId((String)"00:00:00:00:00:01/None"), MacAddress.valueOf((long)0L), VlanId.vlanId(), new HostLocation(DID5, PN1, 1L), (Set)ImmutableSet.of(), new Annotations[]{DefaultAnnotations.EMPTY});
        this.host2 = new DefaultHost(PROVIDER_ID, HostId.hostId((String)"00:00:00:00:00:02/None"), MacAddress.valueOf((long)0L), VlanId.vlanId(), new HostLocation(DID6, PN1, 1L), (Set)ImmutableSet.of(), new Annotations[]{DefaultAnnotations.EMPTY});
        this.edgelink1 = DefaultEdgeLink.createEdgeLink((Host)this.host1, (boolean)true);
        this.edgelink2 = DefaultEdgeLink.createEdgeLink((Host)this.host2, (boolean)false);
        this.path = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link2), 10.0, new Annotations[0]);
        this.pathWithEdgeLink = new DefaultPath(PROVIDER_ID, Arrays.asList(this.edgelink1, this.link1, this.link2, this.edgelink2), 10.0, new Annotations[0]);
    }

    @Test
    public void testEquality() {
        ObstacleConstraint o1 = new ObstacleConstraint(new DeviceId[]{DID1, DID2, DID3});
        ObstacleConstraint o2 = new ObstacleConstraint(new DeviceId[]{DID3, DID2, DID1});
        ObstacleConstraint o3 = new ObstacleConstraint(new DeviceId[]{DID1, DID2});
        ObstacleConstraint o4 = new ObstacleConstraint(new DeviceId[]{DID2, DID1});
        new EqualsTester().addEqualityGroup(new Object[]{o1, o2}).addEqualityGroup(new Object[]{o3, o4}).testEquals();
    }

    @Test
    public void testPathNotThroughObstacles() {
        this.sut = new ObstacleConstraint(new DeviceId[]{DID4});
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPathThroughObstacle() {
        this.sut = new ObstacleConstraint(new DeviceId[]{DID1});
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testPathThroughObstacleWithEdgeLink() {
        this.sut = new ObstacleConstraint(new DeviceId[]{DID1});
        Assert.assertThat((Object)this.sut.validate(this.pathWithEdgeLink, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }
}

