/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.WaypointConstraint;
import org.onosproject.net.provider.ProviderId;

public class WaypointConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final DeviceId DID4 = DeviceId.deviceId((String)"of:4");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private WaypointConstraint sut;
    private ResourceContext resourceContext;
    private Path path;
    private DefaultLink link2;
    private DefaultLink link1;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        this.link1 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN1)).dst(DefaultLinkTest.cp((ElementId)DID2, PN2)).type(Link.Type.DIRECT).build();
        this.link2 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN3)).dst(DefaultLinkTest.cp((ElementId)DID3, PN4)).type(Link.Type.DIRECT).build();
        this.path = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link2), 10.0, new Annotations[0]);
    }

    @Test
    public void testSatisfyWaypoints() {
        this.sut = new WaypointConstraint(new DeviceId[]{DID1, DID2, DID3});
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotSatisfyWaypoint() {
        this.sut = new WaypointConstraint(new DeviceId[]{DID4});
        Assert.assertThat((Object)this.sut.validate(this.path, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEquality() {
        WaypointConstraint c1 = new WaypointConstraint(new DeviceId[]{DID1, DID2});
        WaypointConstraint c2 = new WaypointConstraint(new DeviceId[]{DID1, DID2});
        WaypointConstraint c3 = new WaypointConstraint(new DeviceId[]{DID2});
        WaypointConstraint c4 = new WaypointConstraint(new DeviceId[]{DID3});
        new EqualsTester().addEqualityGroup(new Object[]{c1, c2}).addEqualityGroup(new Object[]{c3}).addEqualityGroup(new Object[]{c4}).testEquals();
    }
}

